% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dataset_functions.R
\name{dataset_cat_as_labels}
\alias{dataset_cat_as_labels}
\title{Apply data dictionary category labels to the associated dataset variables}
\usage{
dataset_cat_as_labels(dataset, data_dict = NULL, col_names = names(dataset))
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations
associated to its data dictionary.}

\item{data_dict}{A list of tibble(s) representing meta data of an
associated dataset (to be generated).}

\item{col_names}{A character string specifying the name(s) of the column(s)
which refer to existing column(s) in the dataset. The column(s) can be named
or indicated by position.}
}
\value{
A tibble identifying a dataset.
}
\description{
Applies category labels declared in a data dictionary to the associated
columns (variables) in the dataset.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

dataset_cat_as_labels(iris['Sepal.Length'])

}

}
