% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-data_visualize.R
\name{variable_visualize}
\alias{variable_visualize}
\title{Generate a list of charts, figures and summary tables of a variable}
\usage{
variable_visualize(
  dataset = tibble(id = as.character()),
  col,
  data_dict = NULL,
  group_by = NULL,
  valueType_guess = FALSE,
  .summary_var = NULL
)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations
associated to its data dictionary.}

\item{col}{A character string specifying the name of the column.}

\item{data_dict}{A list of tibble(s) representing meta data of an
associated dataset. Automatically generated if not provided.}

\item{group_by}{A character string of one column in the dataset that can be
taken as a grouping column. The visual element will be grouped and displayed
by this column.}

\item{valueType_guess}{Whether the output should include a more accurate
valueType that could be applied to the dataset. FALSE by default.}

\item{.summary_var}{A summary list which is the summary of the variables.}
}
\value{
A list of up to seven elements (charts and figures and datatables) which can
be used to summarize visualize data.
}
\description{
Analyses the content of a variable and its data dictionary (if any),
identifies its data type and values accordingly and generates figures and
summaries (datatable format). The figures and tables are representations of
data distribution, statistics and valid/non valid/missing values (based on
the data dictionary information if provided and the data type of the
variable). This function can be used to personalize report parameters and is
internally used in the function \code{\link[=dataset_visualize]{dataset_visualize()}}. Up to seven objects
are generated which include : One datatable of the key elements of the
data dictionary, one datatable summarizing statistics (such as mean,
quartile, most seen value, most recent date, ... , depending on the
data type of the variable), two graphs showing the distribution of the
variable, One bar chart for categorical values (if any), One bar chart for
missing values (if any), One pie chart for the proportion of valid and
missing values (if any). The variable can be grouped using \code{group_by}
parameter, which is a (categorical) column in the dataset. The user may need
to use \code{\link[=as.factor]{as.factor()}} in this context. To fasten the process (and allow
recycling object in a workflow) the user can feed the function with a
\code{.summary_var}, which is the output of the function \code{\link[=dataset_summarize]{dataset_summarize()}}
of the column(s) \code{col} and  \code{group_by}. The summary must have the same
parameters to operate.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

 dataset <- iris['Sepal.Width']
 summary_variable <- dataset_summarize(dataset)
  
 variable_viz <-
    variable_visualize(
    dataset, col = 'Sepal.Width',
    .summary_var =  summary_variable)
 
 variable_viz$summary_table
 variable_viz$main_values_1
 variable_viz$main_values_2
 
}

}
\seealso{
\code{\link[=as.factor]{as.factor()}}
\code{\link[DT:datatable]{DT::datatable()}}, \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
\code{\link[=dataset_summarize]{dataset_summarize()}}, \code{\link[=dataset_visualize]{dataset_visualize()}}
}
