% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setItems.R
\name{setItems}
\alias{setItems}
\title{Set Items}
\usage{
setItems(x, dim, value, maindim = NULL)
}
\arguments{
\item{x}{MAgPIE object}

\item{dim}{Dimension for which the items should be returned. Either number or 
name of dimension or a vector of these. See \code{\link{dimCode}} for more details.}

\item{value}{a vector with the length of the main dimension the dimnames should be replaced in / added to. 
If set to NULL the corresponding dimension will be removed.}

\item{maindim}{main dimension the data should be added to (does not need to be set if \code{dim} exists
in the data. Should be set if \code{dim} might not exist, or if \code{dim} might potentially exist
in a different main dimension than the one anticipated).}
}
\value{
the manipulated MAgPIE object
}
\description{
Set items of a given (sub-)dimension of a MAgPIE-object
}
\examples{
x <- maxample("pop")
setItems(x, "i", paste0("REG",1:ncells(x)))

}
\seealso{
\code{\link{getItems}}
}
\author{
Jan Philipp Dietrich
}
