% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{retrieve}
\alias{retrieve}
\title{Download data from magma as a tsv, and convert to a data.frame}
\usage{
retrieve(
  target,
  projectName,
  modelName,
  recordNames = "all",
  attributeNames = "all",
  filter = "",
  page = NULL,
  pageSize = 10,
  ...
)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{modelName}{Single string. The name of the subset data structure within the project, which are referred to as 'model's in magma, to interact with.
For options, see \code{\link{retrieveModels}} or https://timur.ucsf.edu/<projectName>/map.}

\item{recordNames}{Single string or string vector indicating which particular sample/tube/etc. records to target.
Options are "all" or any combination of individual record names. To retrieve individual options, see \code{\link{retrieveIds}}.}

\item{attributeNames}{Single string or string vector indicating which features of the data to target.
Options are "all" or any combination of individual attribute names. To retrieve individual options, see \code{\link{retrieveAttributes}}.}

\item{filter}{String. Potential filter(s) of the data.
Example: "<targetAttributeName>~GYN" to filter to records where <targetAttributeName> contains "GYN".

Refer to \url{https://mountetna.github.io/magma.html#retrieve} for more details about options and format.}

\item{page}{Integer. For retrieving just a portion of the data, sets which slice to get.}

\item{pageSize}{Integer. For retrieving just a portion of the data, sets slice/page size, which is equivalent to the a number of rows.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}
}
\value{
A dataframe
}
\description{
Analogous to the '/retrieve' function of magma, with \code{format = "tsv"}
}
\details{
This function makes a curl get request to magma/retrieve, with properly reformatted versions of user inputs, plus \code{format = "tsv"}.
Then, it converts the tsv-string output into a dataframe.

Note: When \code{format = "tsv"}, magma/retrieve returns just an identifier for matrix-type attributes.
To retrieve underlying data for such attributes, use the specialized \code{\link{retrieveMatrix}} function.
}
\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    # Now we can retrieve data with...
    retrieve(
        target = magma,
        projectName = "example",
        modelName = "rna_seq",
        recordNames = "all",
        attributeNames = "all",
        filter = "")
}

}
\seealso{
\code{\link{retrieveMatrix}} for retrieving attributes of type matrix.

\code{\link{retrieveJSON}} for similar functionality to \code{retrieve}, but where the call to magma/retrieve is made with \code{format = "json"} and the output is a list.
This output often contains more information, and can retrieve data for attribute types of type matrix, which are not returned by the current function.
But in most cases, the data returned by \code{retrieve} and \code{retrieveMatrix} will suffice.

\url{https://mountetna.github.io/magma.html#retrieve} for documentation of the underlying magma/retrieve function.
}
