% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_spectra.R
\name{check_spectra}
\alias{check_spectra}
\title{Evaluate the spectra regularities}
\usage{
check_spectra(spectra_list)
}
\arguments{
\item{spectra_list}{A list of \link[MALDIquant:MassSpectrum-class]{MALDIquant::MassSpectrum} objects}
}
\value{
A list of logical vectors of length \code{spectra_list} indicating if the spectra are empty (\code{is_empty}), of an odd length (\code{is_outlier_length}) or not a profile spectra (\code{is_not_regular}).
}
\description{
Assess whether all the spectra in the list are not empty, of the same length and correspond to profile data.
}
\examples{
# Get an example directory of six Bruker MALDI Biotyper spectra
directory_biotyper_spectra <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
)
# Import the six spectra
spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)
# Display the list of checks, with FALSE where no anomaly is detected
check_spectra(spectra_list)
# The overall sanity can be checked with Reduce
Reduce(any, check_spectra(spectra_list)) # Should be FALSE
}
\seealso{
\link{process_spectra}
}
