# WARNING - Generated by {fusen} from dev/flat_utils.Rmd: do not edit by hand

#' Check if the list provided is correctly a list of RDS paths
#'
#'
#' @return A logical TRUE if the list indicates paths of RDS files that exists. FALSE otherwise.
#'
#' @noRd
#' @examples
#' is_a_rds_list(list("does-not-exists.RDS"))
is_a_rds_list <- function(rds_list) {
  if (typeof(rds_list[[1]]) != "character") {
    stop(
      "The list does not contain characters"
    )
  }
  exts <- vapply(rds_list, tools::file_ext, FUN.VALUE = character(1)) %>% toupper()
  if (any(exts != "RDS")) {
    stop(
      "The list contains paths that do not end with the expected .RDS suffix."
    )
  }
  existences <- vapply(rds_list, file.exists, FUN.VALUE = logical(1))
  if (any(!existences)) {
    stop(
      "The list contains paths pointing to RDS files that do not exist."
    )
  }
  return(TRUE)
}
