/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.GraphAddEdgeListener;
import salvo.jesus.graph.GraphAddVertexEvent;
import salvo.jesus.graph.GraphAddVertexListener;
import salvo.jesus.graph.GraphFactory;
import salvo.jesus.graph.GraphImplFactory;
import salvo.jesus.graph.GraphListener;
import salvo.jesus.graph.GraphRemoveEdgeEvent;
import salvo.jesus.graph.GraphRemoveEdgeListener;
import salvo.jesus.graph.GraphRemoveVertexEvent;
import salvo.jesus.graph.GraphRemoveVertexListener;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.algorithm.DepthFirstGraphTraversal;
import salvo.jesus.graph.algorithm.GraphTraversal;
import salvo.jesus.graph.listener.ConnectedSetListener;
import salvo.jesus.graph.listener.NullGraphListener;

public class GraphImpl
implements Graph {
    protected GraphFactory factory;
    private Map vertexDataMap = new HashMap();
    private transient Set unmodifiableVertexSet;
    private Set edgeSet = new HashSet();
    private transient Set unmodifiableEdgeSet;
    private List listenerList = new ArrayList(10);
    private ConnectedSetListener connectedSetListener;
    protected GraphTraversal traversal;

    public GraphImpl() {
        this.factory = new GraphImplFactory();
        this.traversal = new DepthFirstGraphTraversal(this);
    }

    public GraphFactory getGraphFactory() {
        return this.factory;
    }

    public void setGraphFactory(GraphFactory factory) {
        this.factory = factory;
    }

    public Iterator getVerticesIterator() {
        return this.getVertexSet().iterator();
    }

    public List cloneVertices() {
        return new ArrayList(this.getVertexSet());
    }

    public Set getVertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.vertexDataMap.keySet());
        }
        return this.unmodifiableVertexSet;
    }

    public Set getEdgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeSet);
        }
        return this.unmodifiableEdgeSet;
    }

    public boolean containsVertex(Vertex v) {
        return this.vertexDataMap.containsKey(v);
    }

    public boolean containsEdge(Edge edge) {
        return this.edgeSet.contains(edge);
    }

    public List getEdges(Vertex v) {
        return this.getVertexData(v).getUnmodifiableIncidentEdges();
    }

    private VertexData getVertexData(Vertex v) {
        return (VertexData)this.vertexDataMap.get(v);
    }

    private List getIncidentEdges(Vertex v) {
        return this.getVertexData(v).getIncidentEdges();
    }

    private void invokeAddVertexListeners(GraphAddVertexEvent event, boolean before) throws Exception {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            GraphListener graphListener = (GraphListener)iter.next();
            if (before) {
                graphListener.beforeVertexAdded(event);
                continue;
            }
            graphListener.afterVertexAdded(event);
        }
    }

    private void invokeRemoveVertexListeners(GraphRemoveVertexEvent event, boolean before) throws Exception {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            GraphListener graphListener = (GraphListener)iter.next();
            if (before) {
                graphListener.beforeVertexRemoved(event);
                continue;
            }
            graphListener.afterVertexRemoved(event);
        }
    }

    private void invokeAddEdgeListeners(GraphAddEdgeEvent event, boolean before) throws Exception {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            GraphListener graphListener = (GraphListener)iter.next();
            if (before) {
                graphListener.beforeEdgeAdded(event);
                continue;
            }
            graphListener.afterEdgeAdded(event);
        }
    }

    private void invokeRemoveEdgeListeners(GraphRemoveEdgeEvent event, boolean before) throws Exception {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            GraphListener graphListener = (GraphListener)iter.next();
            if (before) {
                graphListener.beforeEdgeRemoved(event);
                continue;
            }
            graphListener.afterEdgeRemoved(event);
        }
    }

    public void add(Vertex newvertex) throws Exception {
        if (this.containsVertex(newvertex)) {
            return;
        }
        GraphAddVertexEvent event = new GraphAddVertexEvent(this, newvertex, null);
        this.invokeAddVertexListeners(event, true);
        this.addVertexUnconditionally(event);
    }

    private void addVertexUnconditionally(GraphAddVertexEvent event) throws Exception {
        this.vertexDataMap.put(event.getVertex(), new VertexData());
        this.invokeAddVertexListeners(event, false);
    }

    public Edge addEdge(Vertex v1, Vertex v2) throws Exception {
        Edge edge = this.factory.createEdge(v1, v2);
        this.addEdge(edge);
        return edge;
    }

    public void addEdge(Edge edge) throws Exception {
        if (this.containsEdge(edge)) {
            return;
        }
        Vertex v1 = edge.getVertexA();
        Vertex v2 = edge.getVertexB();
        GraphAddVertexEvent v1addEvent = null;
        GraphAddVertexEvent v2addEvent = null;
        if (!this.containsVertex(v1)) {
            v1addEvent = new GraphAddVertexEvent(this, v1, edge);
        }
        if (v2 != v1 && !this.containsVertex(v2)) {
            v2addEvent = new GraphAddVertexEvent(this, v2, edge);
        }
        if (v1addEvent != null) {
            this.invokeAddVertexListeners(v1addEvent, true);
        }
        if (v2addEvent != null) {
            this.invokeAddVertexListeners(v2addEvent, true);
        }
        GraphAddEdgeEvent event = new GraphAddEdgeEvent(this, edge, v1addEvent != null, v2addEvent != null);
        this.invokeAddEdgeListeners(event, true);
        if (v1addEvent != null) {
            this.addVertexUnconditionally(v1addEvent);
        }
        if (v2addEvent != null) {
            this.addVertexUnconditionally(v2addEvent);
        }
        List v1edges = this.getIncidentEdges(v1);
        v1edges.add(edge);
        if (v1 != v2) {
            List v2edges = this.getIncidentEdges(v2);
            v2edges.add(edge);
        }
        this.edgeSet.add(edge);
        this.invokeAddEdgeListeners(event, false);
    }

    public void remove(Vertex v) throws Exception {
        this.beforeRemoveEdges(v, true);
        GraphRemoveVertexEvent event = new GraphRemoveVertexEvent(this, v);
        this.invokeRemoveVertexListeners(event, true);
        this.removeEdgesUnconditionally(v, true);
        this.vertexDataMap.remove(v);
        this.invokeRemoveVertexListeners(event, false);
    }

    public void removeEdge(Edge edge) throws Exception {
        GraphRemoveEdgeEvent event = new GraphRemoveEdgeEvent(this, edge, null);
        this.invokeRemoveEdgeListeners(event, true);
        this.removeEdgeUnconditionally(event);
    }

    private void removeEdgeUnconditionally(GraphRemoveEdgeEvent event) throws Exception {
        Edge edge = event.getEdge();
        Vertex v1 = edge.getVertexA();
        List v1edges = this.getIncidentEdges(v1);
        v1edges.remove(edge);
        Vertex v2 = edge.getVertexB();
        List v2edges = this.getIncidentEdges(v2);
        v2edges.remove(edge);
        this.edgeSet.remove(edge);
        this.invokeRemoveEdgeListeners(event, false);
    }

    public void removeEdges(Vertex v) throws Exception {
        this.beforeRemoveEdges(v, false);
        this.removeEdgesUnconditionally(v, false);
    }

    private void beforeRemoveEdges(Vertex v, boolean willRemoveVertex) throws Exception {
        Iterator iterator = this.getIncidentEdges(v).iterator();
        while (iterator.hasNext()) {
            Edge edgetoremove = (Edge)iterator.next();
            GraphRemoveEdgeEvent event = new GraphRemoveEdgeEvent(this, edgetoremove, willRemoveVertex ? v : null);
            this.invokeRemoveEdgeListeners(event, true);
        }
    }

    private void removeEdgesUnconditionally(Vertex v, boolean willRemoveVertex) throws Exception {
        ArrayList vedges = new ArrayList(this.getIncidentEdges(v));
        Iterator iterator = vedges.iterator();
        while (iterator.hasNext()) {
            Edge edgetoremove = (Edge)iterator.next();
            GraphRemoveEdgeEvent event = new GraphRemoveEdgeEvent(this, edgetoremove, willRemoveVertex ? v : null);
            this.removeEdgeUnconditionally(event);
        }
    }

    public int getVerticesCount() {
        return this.vertexDataMap.size();
    }

    public int getEdgesCount() {
        return this.edgeSet.size();
    }

    public Set getVertices(int degree) {
        HashSet<Vertex> verticesofsamedegree = new HashSet<Vertex>();
        Iterator iterator = this.getVerticesIterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            if (this.getAdjacentVertices(vertex).size() != degree) continue;
            verticesofsamedegree.add(vertex);
        }
        return Collections.unmodifiableSet(verticesofsamedegree);
    }

    public List getAdjacentVertices(Vertex v) {
        ArrayList<Vertex> adjacentVertices = new ArrayList<Vertex>(10);
        List incidentEdges = this.getEdges(v);
        if (incidentEdges != null) {
            Iterator iterator = incidentEdges.iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Vertex oppositeVertex = edge.getOppositeVertex(v);
                if (oppositeVertex == null) continue;
                adjacentVertices.add(oppositeVertex);
            }
        }
        return Collections.unmodifiableList(adjacentVertices);
    }

    public Set getAdjacentVertices(List vertices) {
        HashSet adjacentVertices = new HashSet(this.getAdjacentVertices((Vertex)vertices.get(0)));
        int size = vertices.size();
        for (int i = 1; i < size; ++i) {
            adjacentVertices.retainAll(this.getAdjacentVertices((Vertex)vertices.get(i)));
        }
        return Collections.unmodifiableSet(adjacentVertices);
    }

    private ConnectedSetListener getConnectedSetListener() {
        if (this.connectedSetListener == null) {
            this.connectedSetListener = new ConnectedSetListener(this);
            this.addListener(this.connectedSetListener);
        }
        return this.connectedSetListener;
    }

    public Collection getConnectedSet() {
        return this.getConnectedSetListener().getConnectedSets();
    }

    public Set getConnectedSet(Vertex v) {
        return this.getConnectedSetListener().getConnectedSet(v);
    }

    public void forgetConnectedSets() {
        if (this.connectedSetListener == null) {
            return;
        }
        this.removeListener(this.connectedSetListener);
        this.connectedSetListener = null;
    }

    public List traverse(Vertex startat) {
        return this.traversal.traverse(startat);
    }

    public GraphTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(GraphTraversal traversal) {
        this.traversal = traversal;
    }

    public boolean isConnected(Vertex v1, Vertex v2) {
        Set connectedsetv1 = this.getConnectedSet(v1);
        return connectedsetv1.contains(v2);
    }

    public int getDegree() {
        Set set = this.getVertexSet();
        if (set.size() > 0) {
            Vertex v = (Vertex)Collections.max(set, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    int countv2;
                    Vertex v1 = (Vertex)obj1;
                    Vertex v2 = (Vertex)obj2;
                    int countv1 = GraphImpl.this.getDegree(v1);
                    if (countv1 < (countv2 = GraphImpl.this.getDegree(v2))) {
                        return -1;
                    }
                    if (countv1 > countv2) {
                        return 1;
                    }
                    return 0;
                }

                public boolean equals(Object objcomparator) {
                    return objcomparator.equals(this);
                }
            });
            return this.getEdges(v).size();
        }
        return 0;
    }

    public int getDegree(Vertex v) {
        return this.getEdges(v).size();
    }

    public void addListener(GraphListener listener) {
        this.listenerList.add(listener);
    }

    public void removeListener(GraphListener listener) {
        this.listenerList.remove(listener);
    }

    public void addGraphAddVertexListener(GraphAddVertexListener listener) {
        this.addListener(new AddVertexListenerAdaptor(listener));
    }

    public void addGraphAddEdgeListener(GraphAddEdgeListener listener) {
        this.addListener(new AddEdgeListenerAdaptor(listener));
    }

    public void addGraphRemoveEdgeListener(GraphRemoveEdgeListener listener) {
        this.addListener(new RemoveEdgeListenerAdaptor(listener));
    }

    public void addGraphRemoveVertexListener(GraphRemoveVertexListener listener) {
        this.addListener(new RemoveVertexListenerAdaptor(listener));
    }

    public void removeGraphAddVertexListener(GraphAddVertexListener listener) {
        this.removeListener(new AddVertexListenerAdaptor(listener));
    }

    public void removeGraphAddEdgeListener(GraphAddEdgeListener listener) {
        this.removeListener(new AddEdgeListenerAdaptor(listener));
    }

    public void removeGraphRemoveEdgeListener(GraphRemoveEdgeListener listener) {
        this.removeListener(new RemoveEdgeListenerAdaptor(listener));
    }

    public void removeGraphRemoveVertexListener(GraphRemoveVertexListener listener) {
        this.removeListener(new RemoveVertexListenerAdaptor(listener));
    }

    public String toString() {
        return "Vertices: " + this.getVertexSet().toString() + "\n " + "Edges: " + this.getEdgeSet().toString();
    }

    private static class RemoveEdgeListenerAdaptor
    extends ListenerAdaptor {
        RemoveEdgeListenerAdaptor(GraphRemoveEdgeListener listener) {
            super(listener);
        }

        public void beforeEdgeRemoved(GraphRemoveEdgeEvent event) {
            ((GraphRemoveEdgeListener)this.listener).edgeRemoved(event);
        }
    }

    private static class AddEdgeListenerAdaptor
    extends ListenerAdaptor {
        AddEdgeListenerAdaptor(GraphAddEdgeListener listener) {
            super(listener);
        }

        public void afterEdgeAdded(GraphAddEdgeEvent event) {
            ((GraphAddEdgeListener)this.listener).edgeAdded(event);
        }
    }

    private static class RemoveVertexListenerAdaptor
    extends ListenerAdaptor {
        RemoveVertexListenerAdaptor(GraphRemoveVertexListener listener) {
            super(listener);
        }

        public void beforeVertexRemoved(GraphRemoveVertexEvent event) {
            ((GraphRemoveVertexListener)this.listener).vertexRemoved(event);
        }
    }

    private static class AddVertexListenerAdaptor
    extends ListenerAdaptor {
        AddVertexListenerAdaptor(GraphAddVertexListener listener) {
            super(listener);
        }

        public void afterVertexAdded(GraphAddVertexEvent event) {
            ((GraphAddVertexListener)this.listener).vertexAdded(event);
        }
    }

    private static abstract class ListenerAdaptor
    extends NullGraphListener {
        protected Object listener;

        protected ListenerAdaptor(Object listener) {
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListenerAdaptor)) {
                return false;
            }
            return this.listener == ((ListenerAdaptor)obj).listener;
        }
    }

    private static class VertexData
    implements Serializable {
        private List incidentEdges = new ArrayList();
        private List unmodifiableIncidentEdges;

        VertexData() {
        }

        final List getIncidentEdges() {
            return this.incidentEdges;
        }

        final List getUnmodifiableIncidentEdges() {
            if (this.unmodifiableIncidentEdges == null) {
                this.unmodifiableIncidentEdges = Collections.unmodifiableList(this.getIncidentEdges());
            }
            return this.unmodifiableIncidentEdges;
        }
    }
}

