/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import salvo.jesus.graph.visual.GraphPanel;
import salvo.jesus.graph.visual.GraphPanelState;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualVertex;

public class GraphPanelEdgeState
extends GraphPanelState {
    VisualVertex sourcevertex;
    Line2D.Double probableedgeline;
    Cursor edgecursor = new Cursor(1);
    Cursor previouscursor;

    public GraphPanelEdgeState(GraphPanel gpanel) {
        super(gpanel);
    }

    public GraphPanelState mousePressed(MouseEvent e) {
        this.sourcevertex = this.gpanel.getVisualGraph().getNode(e.getX(), e.getY());
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseReleased(MouseEvent e) {
        VisualVertex sinkvertex = null;
        this.probableedgeline = null;
        if (this.sourcevertex != null) {
            sinkvertex = this.gpanel.getVisualGraph().getNode(e.getX(), e.getY());
            if (sinkvertex != null) {
                try {
                    this.gpanel.getVisualGraph().addEdge(this.sourcevertex, sinkvertex);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.sourcevertex = null;
        }
        if (this.previouscursor != null) {
            this.gpanel.setCursor(this.previouscursor);
            this.previouscursor = null;
        }
        this.gpanel.repaint();
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseDragged(MouseEvent e) {
        if (this.sourcevertex != null) {
            if (this.probableedgeline == null) {
                this.probableedgeline = new Line2D.Double();
            }
            this.probableedgeline.setLine(this.sourcevertex.getBounds().getCenterX(), this.sourcevertex.getBounds().getCenterY(), e.getX(), e.getY());
            this.gpanel.repaint();
        }
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseMoved(MouseEvent e) {
        VisualVertex vVertex = this.gpanel.getVisualGraph().getNode(e.getX(), e.getY());
        VisualEdge vEdge = this.gpanel.getVisualGraph().getVisualEdge(e.getX(), e.getY());
        if (vVertex != null) {
            if (this.previouscursor == null) {
                this.previouscursor = this.gpanel.getCursor();
            }
            this.gpanel.setCursor(this.edgecursor);
        } else if (this.previouscursor != null) {
            this.gpanel.setCursor(this.previouscursor);
            this.previouscursor = null;
        }
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public void paint(Graphics2D g2d) {
        this.gpanel.getVisualGraph().paint(g2d, this.probableedgeline);
    }
}

