% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dataset.R
\name{median_voter}
\alias{median_voter}
\alias{median_voter_single}
\title{Median Voter position}
\usage{
median_voter(positions, voteshares = "pervote", scale = "rile",
  groups = c("country", "edate"), ...)

median_voter_single(positions, voteshares, adjusted = FALSE,
  scalemin = -100, scalemax = 100)
}
\arguments{
\item{positions}{either a vector of values or (possible only for \code{median_voter}) a data.frame containing a column as
named in argument scale (default: rile) and one as named in argument voteshares (default: pervote);}

\item{voteshares}{either a vector of values or (possible only for \code{median_voter}) the name of a column in the data.frame
\code{positions} that contains the vote shares}

\item{scale}{variable of which to compute the median voter position (default: rile)}

\item{groups}{names of grouping variables to use for aggregation, default
results in one median voter position per election}

\item{...}{further arguments passed to \code{\link{median_voter_single}}}

\item{adjusted}{flag for adjustment after McDonald 2002}

\item{scalemin}{The minimum of the scale of the positions, used for computing the voter position intervals}

\item{scalemax}{The maximum of the scale of the positions, used for computing the voter position intervals}
}
\description{
The position of the median voter, calculated after Kim and Fording (1998; 2003),
with possible adjustment after McDonald 2002.
}
\details{
\code{median_voter} is able to compute the median voter positions for multiple
elections at once, while \code{median_voter_single} treats data as coming from
a single election.

calculated according to the formula
by Kim and Fording (1998; 2003)

\deqn{m = L + \frac{K-C}{F} W}

Where m is the median voter position, L is lower end of the interval
containing the median, K is 0.5*sum(voteshare), C is the cumulative
vote share up to but not including the interval containing the median,
F is the vote share in the interval containing the median
and W is the width of the interval containing the median.

Different parties with the same left-right position
(e.g. alliances) are treated as one party with the cumulative vote share.

In the adjusted formula the midpoint is "mirrored" from the midpoint of
the other side: "Rather than assuming the party's voters are so widely
dispersed, this variable assumes they are spread in a symmetrical
interval around the party's position. For example, for a leftmost
party at -15 and a 0 midpoint between it and an adjacent party on the
right, we assume the left boundary of that party's voters is -30." (McDonald 2002)
}
\references{
Kim, Heemin and Richard C. Fording (1998). "Voter ideology in
western democracies, 1946-1989". In: European Journal of Political Research
33.1, 73-97. doi: 10.1111/1475-6765.00376.

Kim, Heemin and Richard C. Fording (2003). "Voter ideology in Western
democracies: An update". In: European Journal of Political Research 42.1,
95-105.

McDonald, Michael D. (2002). Median Voters: 1950-1995.
url: www2.binghamton.edu/political-science/research/MedianVoter.doc
}

