% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwUI.R
\name{mwUI}
\alias{mwUI}
\title{Generate the UI of a manipulateWidget gadget}
\usage{
mwUI(..., .controlPos = c("left", "top", "right", "bottom", "tab"),
  .tabColumns = 2, .updateBtn = FALSE, .main = "", .outputFun = NULL,
  .outputId = "output", .titleBar = TRUE, .updateInputs = NULL,
  .compare = NULL, .compareLayout = c("v", "h"), .controlList = NULL,
  .container = miniUI::miniContentPanel, .style = "",
  .env = parent.frame())
}
\arguments{
\item{...}{One or more named control arguments created with functions
\code{\link{mwSlider}}, \code{\link{mwText}}, etc. The name of each control
is the name of the variable the controls modifies in the expression. One
can also create a group of inputs by passing a list of such control
arguments. for instance \code{mygroup = list(txt = mwText(""), nb =
mwNumeric(0))} creates a group of inputs named mygroup with two inputs
named "txt" and "nb".}

\item{.controlPos}{Where controls should be placed ? By default, they are
placed in the left, next to the graphic. If \code{controlPos = "tab"}, two
tabs are created: one containing controls and the other containing the
graphic.}

\item{.tabColumns}{If controls are placed in a distinct tab, how many columns
should be used ? This parameter is used only if \code{controlPos = "tab"}}

\item{.updateBtn}{Should an update button be added to the controls ? If
\code{TRUE}, then the graphic is updated only when the user clicks on the
update button.}

\item{.main}{Title of the shiny gadget}

\item{.outputFun}{The output function for the desired htmlwidget.}

\item{.outputId}{Id of the output element in the shiny interface.}

\item{.titleBar}{Whether to include a title bar with controls in the widget}

\item{.updateInputs}{This parameter is similar to `.display` and can be used
to dynamically update input controls. It must be a named list where names
correspond to names of input controls and values are named lists of
expressions where names correspond to arguments of the input generator
function.}

\item{.compare}{Sometimes one wants to compare the same chart but with two
different sets of parameters. This is the purpose of this argument. It must
be a named list whose names are the names of the inputs that should vary
between the two charts. All other parameters are common to the two charts
and changing their values will change the two charts. Each element of the
list must be a vector or a list of length 2 with the initial values of the
corresponding parameter for each chart. It can also be \code{NULL}. In this
case, the parameter is initialized with the default value for the two
charts.}

\item{.compareLayout}{Used only when \code{.compare} is set. Possible values
are "v" for vertical layout (one chart above the other) and "h" for
horizontal layout (one chart on the right of the other)}

\item{.controlList}{List of input controls. This is an alternative to
specifying directly the controls through the \code{...} arguments.}

\item{.container}{tag function that will be used to enclose the UI.}

\item{.style}{CSS style to apply to the container element.}

\item{.env}{Environment used to evaluate the inital values of controls. This
parameter may have an impact on the result only when \code{.updateInputs}
is used.}
}
\value{
A \code{shiny.tag.list} object that can be used in function
\code{\link[shiny]{runGadget}} as ui parameter.
}
\description{
This function can be used if you desire to create a gadget that has the same
UI as a manipulateWidget gadget but with a custom server logic.
}

