% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration_functions.R
\name{integrate_wwtp_agricultural}
\alias{integrate_wwtp_agricultural}
\title{Integrate WWTP Data with Agricultural Classifications (Updated)}
\usage{
integrate_wwtp_agricultural(
  agri_data,
  wwtp_aggregated,
  nutrient,
  cropland_threshold,
  scale = "huc8"
)
}
\arguments{
\item{agri_data}{Data frame. Agricultural classification data}

\item{wwtp_aggregated}{Data frame. Aggregated WWTP loads by spatial unit}

\item{nutrient}{Character. "nitrogen" or "phosphorus"}

\item{cropland_threshold}{Numeric. Threshold for exclusion classification}

\item{scale}{Character. Spatial scale for within-unit classification}
}
\value{
Data frame with combined WWTP + agricultural classifications
}
\description{
Combine WWTP loads with agricultural nutrient balance classifications
}
