% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_4.R
\docType{data}
\name{data_med_mod_serial_cat}
\alias{data_med_mod_serial_cat}
\title{Sample Dataset: Serial
Moderated Mediation with Two
Categorical Moderators}
\format{
A data frame with 300 rows
and 8 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w1}{Moderator. String. Values: "group1", "group2", "group3"}
\item{w2}{Moderator. String. Values: "team1", "team2"}
\item{m1}{Mediator 1. Numeric.}
\item{m2}{Mediator 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_serial_cat
}
\description{
A serial mediation model
with two categorical moderators.
}
\examples{
data(data_med_mod_serial_cat)
dat <- data_med_mod_serial_cat
summary(lm_m1 <- lm(m1 ~ x*w1 + c1 + c2, dat))
summary(lm_m2 <- lm(m2 ~ m1 + x + w1 + c1 + c2, dat))
summary(lm_y <- lm(y ~ m2*w2 + m1 + x + w1 + c1 + c2, dat))
}
\keyword{datasets}
