% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_mod}
\alias{data_mod}
\title{Sample Dataset: One Moderator}
\format{
A data frame with 100 rows
and 5 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w}{Moderator. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_mod
}
\description{
A one-moderator model.
}
\examples{
library(lavaan)
data(data_mod)
data_mod$xw <- data_mod$x * data_mod$w
mod <-
"
y ~ a * x + w + d * xw + c1 + c2
w ~~ v_w * w
w ~ m_w * 1
a_lo := a + d * (m_w - sqrt(v_w))
a_hi := a + d * (m_w + sqrt(v_w))
"
fit <- sem(mod, data_mod, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 3, 6, 7, 24, 25), ]
}
\keyword{datasets}
