% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_autographr.R
\name{autographing}
\alias{autographing}
\alias{autographr}
\alias{autographs}
\alias{autographd}
\title{Quickly graph networks with sensible defaults}
\source{
http://blog.schochastics.net/post/animating-network-evolutions-with-gganimate/

http://blog.schochastics.net/post/animating-network-evolutions-with-gganimate/
}
\usage{
autographr(
  .data,
  layout,
  labels = TRUE,
  node_color,
  node_shape,
  node_size,
  node_group,
  edge_color,
  edge_size,
  ...
)

autographs(netlist, ...)

autographd(
  tlist,
  keep_isolates = TRUE,
  layout = "stress",
  labels = TRUE,
  node_color = NULL,
  node_shape = NULL,
  node_size = NULL,
  edge_color = NULL
)
}
\arguments{
\item{.data}{A manynet-consistent object.}

\item{layout}{An igraph, ggraph, or manynet layout algorithm.
If not declared, defaults to "triad" for networks with 3 nodes,
"quad" for networks with 4 nodes,
"stress" for all other one mode networks,
or "hierarchy" for two mode networks.
For "concentric" layout algorithm please declare the "membership" as an
extra argument.
The "membership" argument expects either a quoted node attribute present
in data or vector with the same length as nodes to draw concentric circles.
For "multilevel" layout algorithm please declare the "level"
as extra argument.
The "level" argument expects either a quoted node attribute present
in data or vector with the same length as nodes to hierarchically
order categories.
If "level" is missing, function will look for 'lvl' node attribute in data.}

\item{labels}{Logical, whether to print node names
as labels if present.}

\item{node_color}{Node variable to be used for coloring the nodes.
It is easiest if this is added as a node attribute to
the graph before plotting.
Nodes can also be colored by declaring a color instead.}

\item{node_shape}{Node variable to be used for shaping the nodes.
It is easiest if this is added as a node attribute to
the graph before plotting.
Nodes can also be shaped by declaring a shape instead.}

\item{node_size}{Node variable to be used for sizing the nodes.
This can be any continuous variable on the nodes of the network.
Since this function expects this to be an existing variable,
it is recommended to calculate all node-related statistics prior
to using this function.
Nodes can also be sized by declaring a numeric size or vector instead.}

\item{node_group}{Node variable to be used for grouping the nodes.
It is easiest if this is added as a hull over
groups before plotting.
Group variables should have a minimum of 3 nodes,
if less, number groups will be reduced by
merging categories with lower counts into one called "other".}

\item{edge_color}{Tie variable to be used for coloring the nodes.
It is easiest if this is added as an edge or tie attribute
to the graph before plotting.
Edges can also be colored by declaring a color instead.}

\item{edge_size}{Edge variable to be used for sizing the edges.
This can be any continuous variable on the nodes of the network.
Since this function expects this to be an existing variable,
it is recommended to calculate all edge-related statistics prior
to using this function.
Edges can also be sized by declaring a numeric size or vector instead.}

\item{...}{Extra arguments to pass on to layout.}

\item{netlist}{A list of manynet-compatible networks.}

\item{tlist}{The same migraph-compatible network listed according to
a time attribute, waves, or slices.}

\item{keep_isolates}{Would you like to remove vertices that do not have
any adjacent edges in each frame?
TRUE by default.
If FALSE, deletes isolated vertices in each frame.}
}
\value{
A ggplot2::ggplot() object.
}
\description{
The aim of this function is to provide users with a quick and easy
graphing function that makes best use of the data,
whatever its composition.
Users can also tailor the plot according to their
preferences regarding node size, colour, and shape.
The function also supports visualisation
of network measures such as centrality.
}
\section{Functions}{
\itemize{
\item \code{autographr()}: Graphs a network with sensible defaults

\item \code{autographs()}: Graphs a list of networks
with sensible defaults

\item \code{autographd()}: Graphs an dynamic (animated) network
with sensible defaults

}}
\examples{
#autographr(ison_adolescents)
#autographr(ison_algebra, layout = "circle", 
#           node_size = 8, node_color = "orange", node_shape = "square",
#           edge_color = "blue", edge_size = 2)
#autographr(ison_algebra, edge_color = "friends",
#           node_size = migraph::node_betweenness(ison_algebra)*100)
#ison_adolescents |> 
#  mutate(cut = migraph::node_is_cutpoint(ison_adolescents)) |> 
#  autographr(node_color = "cut", node_shape = "cut")
#autographr(ison_lotr, node_color = Race, 
#           node_size = migraph::node_degree(ison_lotr)*2,
#           edge_color = "darkgreen",
#           edge_size = migraph::tie_degree(ison_lotr))
#autographr(ison_karateka, node_group = obc,
#           edge_size = migraph::tie_closeness(ison_karateka))
#autographr(ison_southern_women, layout = "concentric", 
#           node_color = "type", membership = "type")
#autographr(ison_lotr, layout = "multilevel",
#           node_color = "Race", node_shape = , level = "Race")
#autographs(to_egos(ison_adolescents))
#ison_adolescents \%>\%
# mutate_ties(year = sample(1995:1998, 10, replace = TRUE)) \%>\%
# to_waves(attribute = "year") \%>\%
# autographd()
#ison_adolescents \%>\%
# mutate(shape = rep(c("circle", "square"), times = 4),
#        color = rep(c("blue", "red"), times = 4),
#        size = sample(4:16, 8, replace = TRUE)) \%>\%
# mutate_ties(year = sample(1995:1998, 10, replace = TRUE),
#        e_color = sample(c("yellow", "green"), 10, replace = TRUE)) \%>\%
# to_waves(attribute = "year") \%>\%
# autographd(keep_isolates = FALSE, layout = "circle", node_shape = "shape",
#            node_color = "color", node_size =  "size",
#            edge_color = "e_color")
}
\seealso{
Other mapping: 
\code{\link{attributes}()},
\code{\link{configuration_layouts}},
\code{\link{is}()},
\code{\link{partition_layouts}},
\code{\link{properties}}
}
\concept{mapping}
