% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manynet-tutorials.R
\name{data_overview}
\alias{data_overview}
\alias{table_data}
\title{Obtain overview of available network data}
\usage{
table_data(pkg = c("manynet", "migraph"), ...)
}
\arguments{
\item{pkg}{String, name of the package.}

\item{...}{Network marks, e.g. directed, twomode, or signed,
that are used to filter the results.}
}
\description{
This function makes it easy to get an overview of available data:
\itemize{
\item \code{table_data()} returns a tibble with details of the
network datasets included in the packages.
}
}
\examples{
table_data()
# to obtain list of all e.g. directed networks:
table_data(pkg = "manynet", directed)
# to obtain overview of unique datasets:
table_data() \%>\% 
  dplyr::distinct(directed, weighted, twomode, signed, 
                 .keep_all = TRUE)
}
