% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{get_vector_tiles}
\alias{get_vector_tiles}
\title{Retrieve vector tiles from a given Mapbox tileset}
\usage{
get_vector_tiles(tileset_id, location, zoom, access_token = NULL)
}
\arguments{
\item{tileset_id}{The name of the tileset ID; names can be retrieved from your Mapbox account}

\item{location}{The location for which you'd like to retrieve tiles.  If the input is an sf object, the function will return data for all tiles that intersect the object's bounding box.  If the input is a coordinate pair or an address, data will be returned for the specific tile that contains the input.}

\item{zoom}{The zoom level of the request; larger zoom levels will return more detail but will take longer to process.}

\item{access_token}{A Mapbox access token; can be set with \code{mb_access_token()}.}
}
\value{
A list of sf objects representing the different layer types found in the requested vector tiles.
}
\description{
Retrieve vector tiles from a given Mapbox tileset
}
\examples{
\dontrun{

library(mapboxapi)
library(ggplot2)

vector_extract <- get_vector_tiles(
  tileset_id = "mapbox.mapbox-streets-v8",
  location = c(-73.99405, 40.72033),
  zoom = 15
)

ggplot(vector_extract$building$polygons) +
  geom_sf() +
  theme_void()
}

}
