% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_map.R
\docType{class}
\name{map-class}
\alias{map-class}
\alias{gmmpp-class}
\title{Classes of MAP}
\description{
Parameters for MAP and MMPP.
}
\section{Slots}{

\describe{
\item{\code{size}}{The number of phases (internal states).}

\item{\code{alpha}}{A probability (row) vector to decide an initial phase.}

\item{\code{D0}}{A square matrix that means transition rates without arrivals.}

\item{\code{D1}}{A square matrix that means transition rates with arrivals. In the case of MMPP, D1 should be a diagonal matrix.}

\item{\code{df}}{The number of free parameters.}
}}

\note{
Objects are usually created by \link{map}, \link{mmpp} or \link{gmmpp}.
}
\examples{
## create an MAP (full matrix) with 5 phases
map(5)

## create an MAP (full matrix) with 5 phases
map(size=5)

## create an MMPP with 5 states
mmpp(5)

## create an MMPP with 5 states for approximate
## estimation
gmmpp(5)

## create an MAP with specific parameters
(param <- map(alpha=c(1,0,0),
              D0=rbind(c(-4,2,0),c(2,-5,1),c(1,0,-4)),
              D1=rbind(c(1,1,0),c(1,0,1),c(2,0,1))))

## marginal moments of MAP
map.mmoment(k=3, map=param)

## joint moments of MAP
map.jmoment(lag=1, map=param)

## k-lag correlation
map.acf(map=param)

}
\seealso{
Classes \code{\linkS4class{erhmm}}.
}
\keyword{classes}
