% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hover.R
\name{enable_shiny_hover}
\alias{enable_shiny_hover}
\title{Enable hover events for Shiny applications}
\usage{
enable_shiny_hover(map, coordinates = TRUE, features = TRUE)
}
\arguments{
\item{map}{A maplibre or mapboxgl widget object.}

\item{coordinates}{Logical. If TRUE, provides general mouse coordinates via \verb{_hover} input. Defaults to TRUE.}

\item{features}{Logical. If TRUE, provides feature information via \verb{_feature_hover} input when hovering over map features. Defaults to TRUE.}
}
\value{
The modified map object with hover events enabled.
}
\description{
This function enables hover functionality for maplibre and mapboxgl widgets
in Shiny applications, providing \verb{_hover} and \verb{_feature_hover} input values.
}
\examples{
\dontrun{
library(shiny)
library(mapgl)

ui <- fluidPage(
  maplibreOutput("map"),
  verbatimTextOutput("hover_info")
)

server <- function(input, output) {
  output$map <- renderMaplibre({
    maplibre() |>
      enable_shiny_hover()
  })
  
  output$hover_info <- renderText({
    paste("Mouse at:", input$map_hover$lng, input$map_hover$lat)
  })
}

shinyApp(ui, server)
}
}
