% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_accessibility.R
\docType{data}
\name{accessibility}
\alias{accessibility}
\title{Calculate accessibility statistics}
\format{
A tibble with a column for accessibility statistics (in minutes)
}
\description{
Accessibility is the ease with which larger cities can be reached from a
certain location. This function allows to efficiently calculate accessibility
statistics (i.e. travel time to nearby major cities) for polygons. For each
polygon, the desired statistic/s (mean, median or sd) is/are returned.
The required resources for this indicator are:
\itemize{
\item \link{traveltime}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_accessibility}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
library(sf)
library(mapme.biodiversity)

temp_loc <- file.path(tempdir(), "mapme.biodiversity")
if(!file.exists(temp_loc)){
dir.create(temp_loc)
resource_dir <- system.file("res", package = "mapme.biodiversity")
file.copy(resource_dir, temp_loc, recursive = TRUE)
}

(try(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
                        package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2022,
    outdir = file.path(temp_loc, "res"),
    tmpdir = tempdir(),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("traveltime",
    range_traveltime = c("5k_10k", "100k_200k", "500k_1mio", "1mio_5mio")
  ) \%>\%
  calc_indicators("accessibility", stats_accessibility = c("min", "max"), engine = "extract") \%>\%
  tidyr::unnest(accessibility)))
}
\keyword{indicator}
