% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_deforestation_drivers.R
\name{deforestation_drivers}
\alias{deforestation_drivers}
\alias{calc_deforestation_drivers}
\title{Calculate deforestation drivers}
\usage{
calc_deforestation_drivers()
}
\value{
A function that returns an indicator tibble with deforestation
drivers as variable and corresponding area (in ha) as value.
}
\description{
This function extracts areal statistics for the drivers of deforestation
based on the data source produced by Fritz et al (2022).
}
\details{
The required resource for this indicator is:
\itemize{
\item \link{fritz_et_al}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_fritz_et_al(resolution = 100)) \%>\%
  calc_indicators(calc_deforestation_drivers()) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
