% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_carbon.R
\name{carbon_indicators}
\alias{carbon_indicators}
\alias{calc_irr_carbon}
\alias{calc_man_carbon}
\alias{calc_vul_carbon}
\title{Calculate carbon statistics}
\usage{
calc_irr_carbon(
  type = c("total", "soil", "biomass", "all"),
  engine = "extract",
  stats = "mean"
)

calc_man_carbon(
  type = c("total", "soil", "biomass", "all"),
  engine = "extract",
  stats = "mean"
)

calc_vul_carbon(
  type = c("total", "soil", "biomass", "all"),
  engine = "extract",
  stats = "mean"
)
}
\arguments{
\item{type}{One of "total", "soil", "biomass", "all". Determines
for which data layer the statistics are calculated.}

\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum", and "var".}
}
\value{
A function that returns an indicator tibble with \verb{(type)_carbon_(stat)}
as variable and the respective statistic (in Mg) as value.
}
\description{
These functions allow to calculated statistics based on the harmonized
carbon layers for 2010 and 2018 by Noon et al. (2022).
}
\details{
The required resources for these indicators are:
\itemize{
\item \link{carbon_resources}
}

Irrecoverable carbon is the amount of carbon that, if lost today, could not
be recovered until 2050. It can be calculated for above- and below-ground
carbon, the total amount of carbon, or for all layers.

Manageable carbon is the amount of carbon that, in principle, is manageable
by human activities, e.g. its release to the atmosphere can be prevented.
It can be calculated for above- and below-ground carbon, the total amount
of carbon, or for all layers.

Vulnerable carbon is the amount of carbon that would be released in a typical
land conversion activity.
It can be calculated for above- and below-ground carbon, the total amount
of carbon, or for all layers.
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(
    get_man_carbon(),
    get_vul_carbon(),
    get_irr_carbon()
  ) \%>\%
  calc_indicators(
    calc_man_carbon(stats = "sum"),
    calc_vul_carbon(stats = "sum"),
    calc_irr_carbon(stats = "sum")
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
