% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartography_chamber.R
\name{create_mapper_object}
\alias{create_mapper_object}
\title{Create a mapper object}
\usage{
create_mapper_object(
  data,
  dists,
  filtered_data,
  cover_element_tests,
  method = "none"
)
}
\arguments{
\item{data}{A data frame.}

\item{dists}{A distance matrix for the data frame.}

\item{filtered_data}{The result of a function applied to the data frame; there should be one filter value per observation in the original data frame.}

\item{cover_element_tests}{A list of membership test functions for a set of cover elements. In other words, each element of \code{cover_element_tests} is a function that returns \code{TRUE} or \code{FALSE} when given a filter value.}

\item{method}{A string to pass to \link{hclust} to determine clustering method.}
}
\value{
A list of two dataframes, one with node data and one with edge data.
}
\description{
Run the mapper algorithm on a data frame.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
projx = data$x

num_bins = 10
percent_overlap = 25
xcover = create_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

check_in_interval <- function(endpoints) {
 return(function(x) (endpoints[1] - x <= 0) & (endpoints[2] - x >= 0))
}

# each of the "cover" elements will really be a function that checks if a data point lives in it
xcovercheck = apply(xcover, 1, check_in_interval)

# build the mapper object
xmapper = create_mapper_object(
  data = data,
  dists = dist(data),
  filtered_data = projx,
  cover_element_tests = xcovercheck,
  method = "single"
)
}
