context("Two point estimates")
test_that("estimate two-points rf correctly", {
  dat <- filter_missing(tetra.solcap, inter = FALSE)
  expect_identical(round(mean(as.matrix(dat$geno.dose)),6), 1.926265)
  dat <- filter_missing(tetra.solcap, inter = FALSE, type = "individual")
  expect_identical(round(mean(as.matrix(dat$geno.dose)),6), 1.931187)
  f <- filter_segregation(dat, inter = FALSE)
  expect_equivalent(length(f$keep), 3677)
  s <- make_seq_mappoly(tetra.solcap, f$keep)
  s <- make_seq_mappoly(tetra.solcap, s$seq.mrk.names[seq(1,length(s$seq.num), 50)])
  tpt1 <- est_pairwise_rf(s)
  expect_is(plot(tpt1, first.mrk = 1, second.mrk = 101), "ggplot")
  m <- rf_list_to_matrix(tpt1)
  m2 <- make_mat_mappoly(m, make_seq_mappoly(tetra.solcap, names(which(s$sequence==1))))
  expect_equal(sum(m2$rec.mat, na.rm = TRUE), 12.51488, tolerance = 10e-5)
  o <- mds_mappoly(m)
  expect_is(o, "mappoly.pcmap")
  expect_null(plot(m))
  expect_equivalent(round(mean(m[[4]], na.rm = T),6), 0.395504)
  skip_on_os("mac")
  tpt2 <- est_pairwise_rf(s, ncpus = 2)
  expect_identical(tpt1, tpt2)
  sf<-rf_snp_filter(tpt2)
  expect_is(sf, "mappoly.sequence")
  expect_equal(sum(sf$seq.num), 51417)
})