% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ggplot.R
\name{map_ggplot}
\alias{map_ggplot}
\title{ggplot2 mapping}
\usage{
map_ggplot(x, map = "world", point_color = "#86161f", color = NULL,
  size = 3, lon = "longitude", lat = "latitude", ...)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{SpatialPoints}, \code{SpatialPointsDataFrame}, or
\code{data.frame}. The package \pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{map}{(character) One of world, world2, state, usa, county, france,
italy, or nz}

\item{point_color}{Default color of your points. Deprecated, use
\code{color}}

\item{color}{Default color of your points.}

\item{size}{point size, Default: 3}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess, but
if nothing close, we stop. Default: \code{longitude} and \code{latitude}}

\item{...}{Ignored}
}
\value{
A ggplot2 map, of class \code{gg/ggplot}
}
\description{
ggplot2 mapping
}
\examples{
# map spocc output, here using a built in object
data(occdat_eg1)
map_ggplot(occdat_eg1)

# map rgbif output, here using a built in object
data(gbif_eg1)
map_ggplot(gbif_eg1)

}

