% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_get_matrix.R
\name{mp_get_matrix}
\alias{mp_get_matrix}
\title{Extract distance or duration *matrix* from a Google Maps Distance Matrix API response}
\usage{
mp_get_matrix(doc, value = "distance_m")
}
\arguments{
\item{doc}{XML document with Google Maps Distance Matrix API response}

\item{value}{Value to extract, one of: \code{"distance_m"} (default), \code{"distance_text"}, \code{"duration_s"}, \code{"duration_text"}}
}
\value{
\code{matrix}
}
\description{
Extract distance or duration *matrix* from a Google Maps Distance Matrix API response
}
\examples{
library(xml2)
doc = as_xml_document(response_matrix)
mp_get_matrix(doc, value = "distance_m")
mp_get_matrix(doc, value = "distance_text")
mp_get_matrix(doc, value = "duration_s")
mp_get_matrix(doc, value = "duration_text")
\dontrun{
locations = c("Haifa", "Tel-Aviv", "Jerusalem", "Beer-Sheva")
doc = mp_matrix(
  origins = locations,
  destinations = locations
)
mp_get_matrix(doc, value = "distance_m")
mp_get_matrix(doc, value = "distance_text")
mp_get_matrix(doc, value = "duration_s")
mp_get_matrix(doc, value = "duration_text")
}
}
