% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_get_breaks.R
\name{mf_get_breaks}
\alias{mf_get_breaks}
\title{Get class intervals}
\usage{
mf_get_breaks(x, nbreaks, breaks, k = 1, central = FALSE, ...)
}
\arguments{
\item{x}{a vector of numeric values}

\item{nbreaks}{a number of classes}

\item{breaks}{a classification method; one of "fixed", "sd", "equal",
"pretty", "quantile",
"kmeans", "hclust", "bclust", "fisher", "jenks", "dpih", "q6", "geom",
 "arith", "em" or "msd" (see Details).}

\item{k}{number of standard deviation for "msd" method (see Details)}

\item{central}{creation of a central class for "msd" method (see Details)}

\item{...}{further arguments
of \code{\link[classInt:classIntervals]{classIntervals}}}
}
\value{
A numeric vector of breaks
}
\description{
A function to classify continuous variables.
}
\details{
"fixed", "sd", "equal", "pretty", "quantile", "kmeans", "hclust",
"bclust", "fisher", "jenks" and "dpih"
are \code{\link[classInt:classIntervals]{classIntervals}}
methods. You may need to pass additional arguments for some of them.\cr\cr
Jenks ("jenks" method) and Fisher ("fisher" method) algorithms are
based on the same principle and give
quite similar results but Fisher is much faster. \cr\cr
The "q6" method uses the following \code{\link[stats:quantile]{quantile}}
probabilities: 0, 0.05, 0.275, 0.5, 0.725, 0.95, 1.\cr\cr
The "geom" method is based on a geometric progression along
the variable values.\cr\cr
The "arith" method is based on an arithmetic progression along
the variable values.\cr\cr
The "em" method is based on nested averages computation.\cr\cr
The "msd" method is based on the mean and the standard deviation
of a numeric vector.
The \code{nbreaks} parameter is not relevant, use \code{k} and
\code{central} instead. \code{k} indicates
the extent of each class in share of standard deviation.
If \code{central=TRUE} then
the mean value is the center of a class else the mean is a break value.
}
\note{
This function is mainly a wrapper
of \code{\link[classInt:classIntervals]{classIntervals}} +
"arith", "em", "q6", "geom" and "msd" methods.
}
\examples{
mtq <- mf_get_mtq()
mf_get_breaks(x = mtq$MED, nbreaks = 6, breaks = "quantile")
}
\seealso{
\link[classInt:classIntervals]{classIntervals}
}
