% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spplot.R
\docType{methods}
\name{spplot}
\alias{spplot}
\alias{spplot,mapview-method}
\title{spplot method for objects of class 'mapview'}
\usage{
\S4method{spplot}{mapview}(obj, zoom = NULL,
  col.regions = mapviewPalette(256), alpha.regions = 0.8, ...)
}
\arguments{
\item{obj}{an object of class 'mapview'}

\item{zoom}{Zoom level, see \code{\link{openmap}}.}

\item{col.regions, alpha.regions}{See \code{\link[sp]{spplot}}.}

\item{...}{Further arguments passed on to \code{\link[sp]{spplot}}.}
}
\description{
this function attempts to produce a static version of the specified
mapview object that looks similar to the interactive version.
}
\examples{
\dontrun{
library(sp)
m1 <- mapview(breweries91, zcol = "zipcode")
spplot(m1)

m2 <- mapview(gadmCHE, zcol = "NAME_1")
spplot(m2)
}

}
\author{
Tim Appelhans, Florian Detsch
}

