% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMouseCoordinates.R
\name{addMouseCoordinates}
\alias{addMouseCoordinates}
\title{Add mouse coordinate information at top of map.}
\usage{
addMouseCoordinates(map)
}
\arguments{
\item{map}{a mapview or leaflet object.}
}
\description{
This function adds a box displaying the current cursor location
(latitude, longitude and zoom level) at the top of a rendered
mapview or leaflet map. In case of mapview, this is automatically added.
NOTE: The information will only render once a mouse movement has happened
on the map.
}
\examples{
\dontrun{
leaflet() \%>\% addTiles() # without mouse position info
leaflet() \%>\% addTiles() \%>\% addMouseCoordinates() # with mouse position info
mapview(easter.egg = TRUE) # mouse position info by default
}


}

