% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords2JSON.R
\docType{methods}
\name{coords2JSON}
\alias{coords2JSON}
\alias{coords2JSON,character-method}
\alias{coords2JSON,matrix-method}
\alias{coords2JSON,numeric-method}
\title{Convert a vector/matrix of coordinates to JSON format}
\usage{
\S4method{coords2JSON}{numeric}(x)

\S4method{coords2JSON}{character}(x, xy = c(1, 2))

\S4method{coords2JSON}{matrix}(x, xy = c(1, 2))
}
\arguments{
\item{x}{A 'numeric' vector with a single pair of coordinates or a matrix
with multiple pairs of input coordinates, typically projected in EPSG:4326
(\url{http://spatialreference.org/ref/epsg/wgs-84/}).}

\item{xy}{An 'integer' vector specifying the coordinate columns.}
}
\value{
A single 'character' object in JSON format.
}
\description{
Similar to \code{toJSON} from \strong{jsonlite}, this function takes a
set of coordinates as input and converts them to proper JSON format. Note
that the function is powered by \strong{Rcpp} which makes it a convenient
alternative to existing methods when it comes to processing big datasets.
}
\examples{
crd <- matrix(ncol = 3, nrow = 12)

# x-coordinates
set.seed(10)
crd[, 1] <- rnorm(nrow(crd), 10, 3)

# y-coordinates
set.seed(10)
crd[, 2] <- rnorm(nrow(crd), 50, 3)

# additional data
crd[, 3] <- month.abb

# reformat a single pair of coordinates
coords2JSON(crd[1, ])

# reformat multiple pairs of coordinates at once
coords2JSON(crd)

}
\author{
Florian Detsch
}

