% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{addHomeButton}
\alias{addHomeButton}
\alias{removeHomeButton}
\title{Add a home button / zoom-to-layer button to a map.}
\usage{
addHomeButton(map, ext, layer.name = "layer", position = "bottomright",
  add = TRUE)

removeHomeButton(map)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{ext}{the \code{\link{extent}} / \code{\link{bbox}} to zoom to.}

\item{layer.name}{the name of the layer to be zoomed to (or any character
string)}

\item{position}{the position of the button (one of 'topleft', 'topright',
'bottomleft', 'bottomright'). Defaults to 'bottomright'.}

\item{add}{logical. Whether to add the button to the map (mainly for internal use).}
}
\description{
This function adds a button to the map that enables zooming to a
provided \code{\link{extent}} / \code{\link{bbox}}.

Use removeHomeButton to remove home button
}
\section{Functions}{
\itemize{
\item \code{removeHomeButton}: remove a homeButton from a map
}}

\examples{
library(leaflet)
library(raster)

m <- leaflet() \%>\%
  addProviderTiles("OpenStreetMap") \%>\%
  addCircleMarkers(data = breweries) \%>\%
  addHomeButton(extent(breweries), "breweries")
m

## remove the button
removeHomeButton(m)


}
