% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predict.R, R/methods_MASS.R,
%   R/methods_MCMCglmm.R, R/methods_afex.R, R/methods_aod.R,
%   R/methods_betareg.R, R/methods_bife.R, R/methods_biglm.R, R/methods_nnet.R,
%   R/methods_brglm2.R, R/methods_brms.R, R/methods_crch.R, R/methods_fixest.R,
%   R/methods_gamlss.R, R/methods_glmmTMB.R, R/methods_inferences_simulation.R,
%   R/methods_lme4.R, R/methods_mclogit.R, R/methods_mhurdle.R,
%   R/methods_mlogit.R, R/methods_ordinal.R, R/methods_quantreg.R,
%   R/methods_rms.R, R/methods_robustlmm.R, R/methods_rstanarm.R,
%   R/methods_stats.R, R/methods_survival.R, R/methods_tobit1.R
\name{get_predict}
\alias{get_predict}
\alias{get_predict.default}
\alias{get_predict.polr}
\alias{get_predict.glmmPQL}
\alias{get_predict.MCMCglmm}
\alias{get_predict.afex_aov}
\alias{get_predict.glimML}
\alias{get_predict.betareg}
\alias{get_predict.bife}
\alias{get_predict.biglm}
\alias{get_predict.multinom}
\alias{get_predict.brmultinom}
\alias{get_predict.brmsfit}
\alias{get_predict.crch}
\alias{get_predict.fixest}
\alias{get_predict.gamlss}
\alias{get_predict.glmmTMB}
\alias{get_predict.inferences_simulation}
\alias{get_predict.merMod}
\alias{get_predict.lmerModLmerTest}
\alias{get_predict.lmerMod}
\alias{get_predict.mblogit}
\alias{get_predict.mhurdle}
\alias{get_predict.mlogit}
\alias{get_predict.clm}
\alias{get_predict.rq}
\alias{get_predict.rms}
\alias{get_predict.orm}
\alias{get_predict.lrm}
\alias{get_predict.ols}
\alias{get_predict.rlmerMod}
\alias{get_predict.stanreg}
\alias{get_predict.lm}
\alias{get_predict.glm}
\alias{get_predict.coxph}
\alias{get_predict.tobit1}
\title{Get predicted values from a model object (internal function)}
\usage{
get_predict(model, newdata, type, ...)

\method{get_predict}{default}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{polr}(model, newdata = insight::get_data(model), type = "probs", ...)

\method{get_predict}{glmmPQL}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{MCMCglmm}(model, newdata, type = "response", ndraws = 1000, ...)

\method{get_predict}{afex_aov}(model, newdata = NULL, ...)

\method{get_predict}{glimML}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{betareg}(model, newdata, ...)

\method{get_predict}{bife}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{biglm}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{multinom}(model, newdata = insight::get_data(model), type = "probs", ...)

\method{get_predict}{brmultinom}(model, newdata = insight::get_data(model), type = "probs", ...)

\method{get_predict}{brmsfit}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{crch}(model, newdata = NULL, type = "location", ...)

\method{get_predict}{fixest}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{gamlss}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{glmmTMB}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{inferences_simulation}(model, newdata, ...)

\method{get_predict}{merMod}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{lmerModLmerTest}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{lmerMod}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{mblogit}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{mhurdle}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{mlogit}(model, newdata, ...)

\method{get_predict}{clm}(model, newdata = insight::get_data(model), type = "prob", ...)

\method{get_predict}{rq}(model, newdata = insight::get_data(model), type = NULL, ...)

\method{get_predict}{rms}(model, newdata = insight::get_data(model), type = NULL, ...)

\method{get_predict}{orm}(model, newdata = insight::get_data(model), type = NULL, ...)

\method{get_predict}{lrm}(model, newdata = insight::get_data(model), type = NULL, ...)

\method{get_predict}{ols}(model, newdata = insight::get_data(model), type = NULL, ...)

\method{get_predict}{rlmerMod}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{stanreg}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{lm}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{glm}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{coxph}(model, newdata = insight::get_data(model), type = "lp", ...)

\method{get_predict}{tobit1}(model, newdata = insight::get_data(model), type = "response", ...)
}
\arguments{
\item{model}{Model object}

\item{newdata}{Grid of predictor values at which we evaluate the slopes.
\itemize{
\item \code{NULL} (default): Unit-level slopes for each observed value in the original dataset. See \code{\link[insight:get_data]{insight::get_data()}}
\item data frame: Unit-level slopes for each row of the \code{newdata} data frame.
\item \code{\link[=datagrid]{datagrid()}} call to specify a custom grid of regressors. For example:
\itemize{
\item \code{newdata = datagrid(cyl = c(4, 6))}: \code{cyl} variable equal to 4 and 6 and other regressors fixed at their means or modes.
\item See the Examples section and the \code{\link[=datagrid]{datagrid()}} documentation.
}
\item string:
\itemize{
\item "mean": Marginal Effects at the Mean. Slopes when each predictor is held at its mean or mode.
\item "median": Marginal Effects at the Median. Slopes when each predictor is held at its median or mode.
\item "marginalmeans": Marginal Effects at Marginal Means. See Details section below.
\item "tukey": Marginal Effects at Tukey's 5 numbers.
\item "grid": Marginal Effects on a grid of representative numbers (Tukey's 5 numbers and unique values of categorical predictors).
}
}}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
default value is used. This default is the first model-related row in
the \code{marginaleffects:::type_dictionary} dataframe.}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}
}
\value{
A data.frame of predicted values with a number of rows equal to the
number of rows in \code{newdata} and columns "rowid" and "estimate". A "group"
column is added for multivariate models or models with categorical outcomes.
}
\description{
Get predicted values from a model object (internal function)
}
\keyword{internal}
