% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lapply.R
\name{lapply_kfold_species}
\alias{lapply_kfold_species}
\title{Apply a function over the folds of a set of species}
\usage{
lapply_kfold_species(fun, ..., species = NULL, fold_type = "disc", k =
  1:5)
}
\arguments{
\item{fun}{function. The function to be applied to the occurrence records of
each species. Parameters are the species name, a list with the occurrence
and background training and test records and a fold number.}

\item{...}{optional arguments to \code{fun}.}

\item{species}{dataframe or character vector. Dataframe like returned by
\code{\link{list_species}} or the names of the species. If \code{NULL}
(default) then \code{fun} is applied for all species.}

\item{fold_type}{character. Type of partitioning you want to use, default is
\code{"disc"}.}

\item{k}{integer vector. Numbers of the folds you want to get data for, if
you want all 5-folds pass use \code{1:5}, which is the default.}
}
\value{
A list with one named entry for every species provided or for all
  species. Every list entry is a list with \code{k} as names and the result
  of \code{fun} as value.
}
\description{
\code{lapply_kfold_species} returns a list of lists where each element is the
result of applying \code{fun} to all species or the provided subset of
species for the specified folds.
}
\details{
The parameters passed to \code{fun} are \code{speciesname},
  \code{data} where \code{data} is a list with 4 elements
  (\code{occurrence_training}, \code{occurrence_test},
  \code{background_training} and \code{background_test}) and a parameter
  \code{fold} which contains the fold number.

  The different \code{fold_type} are:

  \code{"disc"}: 5-fold disc partitioning of occurrences with pairwise
  distance sampled and buffer filtered random background points, equivalent
  to calling \code{\link{kfold_occurrence_background}} with
  \code{occurrence_fold_type = "disc", k = 5, pwd_sample = TRUE,
  background_buffer = 200*1000}

  \code{"grid_4"} and \code{"grid_9"}: 4-fold and 9-fold grid partitioning of
  occurrences with pairwise distance sampled and buffer filtered random
  background points, equivalent to calling
  \code{\link{kfold_occurrence_background}} with \code{occurrence_fold_type =
  "grid", k = 4, pwd_sample = TRUE, background_buffer = 200*1000}

  \code{"random"}: 5-fold random partitioning of occurrences and random
  background points, equivalent to calling
  \code{\link{kfold_occurrence_background}} with \code{occurrence_fold_type =
  "random", k = 5, pwd_sample = FALSE, background_buffer = 0}

  \code{"targetgroup"}: same way of partitioning as the \code{"random"} folds
  but instead of random background points, a random subset of all occurrences
  points was used creating a targetgroup background points set which has the
  same sampling bias as the entire dataset.
}
\examples{
\dontrun{
plot_occurrences <- function(speciesname, data, fold) {
   title <- paste0(speciesname, " (fold = ", fold, ")")
   plot(data$occurrence_train[,c("longitude", "latitude")], pch=".",
        col="blue", main = title)
   points(data$occurrence_test[,c("longitude", "latitude")], pch=".",
        col="red")
}

# plot training (blue) and test (red) occurrences
# of the first 2 folds for the first 10 species
species <- list_species()
lapply_kfold_species(plot_occurrences, species=species[1:5,],
                     fold_type = "disc", k = 1:2)
}
}
\seealso{
\code{\link{list_species}} \code{\link{lapply_species}}
  \code{\link{get_fold_data}}

\code{\link{lapply_species}}, \code{\link{get_fold_data}},
  \code{\link{list_species}}
}

