% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix_utils.R
\name{restate}
\alias{restate}
\title{Reorganize states in MarkovMix object}
\usage{
restate(.object, .fun, .check = TRUE, ...)
}
\arguments{
\item{.object}{\code{\link{MarkovMix}} object.}

\item{.fun}{Function to process each column in state transition patterns as factors,
such as those in \code{\link[forcats:forcats-package]{forcats}} package.}

\item{.check}{Logical (1L) indicating whether to check \code{object}
at the beginning.}

\item{...}{Additional arguments passed on to \code{.fun}.}
}
\value{
A \code{\link{MarkovMix}} object with modified states and count matrix.
}
\description{
\code{restate} reorganizes states in \code{\link{MarkovMix}} object with a function.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the class.}
}
}
\examples{
# Load example MarkovMix object
data("markov_mix_ex")

# Reverse states (using function name)
markov_mix_new1 <- restate(
  .object = markov_mix_ex,
  .fun = forcats::fct_rev
)
print(markov_mix_new1)

# Reorder states by hand (using function name with additional arguments)
markov_mix_new2 <- restate(
  .object = markov_mix_ex,
  .fun = "levels<-",
  value = c("B", "D", "C", "A")
)
print(markov_mix_new2)

# Merge state D into C (using purrr-style lambda function)
markov_mix_new3 <- restate(
  .object = markov_mix_ex,
  .fun = ~ forcats::fct_recode(.x, "C" = "D")
)
print(markov_mix_new3)
}
\seealso{
Other MarkovMix utilities: 
\code{\link{get_prior}()},
\code{\link{get_prob}()},
\code{\link{get_states_mat}()}
}
\author{
Xiurui Zhu
}
\concept{MarkovMix utilities}
