% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_marquee.R
\name{marquefy_theme}
\alias{marquefy_theme}
\title{Convert all text elements in a theme to marquee elements}
\usage{
marquefy_theme(theme)
}
\arguments{
\item{theme}{A (complete) ggplot2 theme}
}
\value{
\code{theme} with all text elements substituted for marquee elements
}
\description{
While \code{\link[=element_marquee]{element_marquee()}} should behave similar to \code{ggplot2::element_text()}
when used on plain text (i.e. text without any markdown markup), the reality
can be different. This is because the text shaping engine used by marquee
(\code{\link[textshaping:shape_text]{textshaping::shape_text()}}) may differ from the one used by the graphics
device (which is responsible for laying out text in \code{element_text()}).
Differences can range from slight differences in letter spacing to using a
different font altogether (this is because the font keywords \code{""}, \code{"sans"},
\code{"serif"}, \code{"mono"}, and \code{"symbol"} may be mapped to different fonts
depending on the shaper). One way to handle this is to provide an explicit
font name for the elements, but alternatively you can use this function to
convert all text elements in a theme to \code{\link[=element_marquee]{element_marquee()}}
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
ggplot(mtcars) +
  geom_point(aes(disp, mpg)) +
  ggtitle("How about that") +
  marquefy_theme(theme_gray())
\dontshow{\}) # examplesIf}
}
