% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm.R
\name{rangeSVM_predict}
\alias{rangeSVM_predict}
\title{Generate a raster based on predictions of SVM model with values corresponding to the species.}
\usage{
rangeSVM_predict(svm, r, sdm = NULL)
}
\arguments{
\item{svm}{Model object for the SVM, returned by \code{rangeSVM()}.}

\item{r}{Raster with the extent desired for the prediction. The values for cells used for predictions must 
have non-NA values, but the particular values do not matter.}

\item{sdm}{Raster or RasterStack representing environmental suitability (can be predictions from SDMs).
These rasters must match the predictor variables used in the SVM. Default is NULL.}
}
\value{
The  Raster representing the SVM predictions.
}
\description{
\code{rangeSVM_predict()} returns a raster representing the ranges of the species
predicted by the fitted SVM tuned with \code{rangeSVM()}.
}
\details{
The values of the output raster are 1, 2, ..., corresponding to xy1, xy2, and any additional species used in \code{rangeSVM()}.
These values represent the identities of the species.
}
\examples{
\donttest{
r1.sdm <- raster::raster(raster::extent(c(-72, -64, 41, 50)), res = c(0.008333333, 0.008333333))
raster::values(r1.sdm) <- (1:raster::ncell(r1.sdm))^2
r2.sdm <- raster::raster(raster::extent(c(-72, -64, 41, 50)), res = c(0.008333333, 0.008333333))
raster::values(r2.sdm) <- (raster::ncell(r2.sdm):1)^2
r3.sdm <- raster::raster(raster::extent(c(-72, -64, 41, 50)), res = c(0.008333333, 0.008333333))
r3.sdm [1] <- 10
r3.sdm <- raster::distance(r3.sdm)
sp1.xy <- data.frame(dismo::randomPoints(r1.sdm, 15, prob = TRUE))
colnames(sp1.xy) <- c("longitude", "latitude")
sp2.xy <- data.frame(dismo::randomPoints(r2.sdm, 15, prob = TRUE))
colnames(sp2.xy) <- c("longitude", "latitude")
sp3.xy <- data.frame(dismo::randomPoints(r3.sdm, 15, prob = TRUE))
colnames(sp3.xy) <- c("longitude", "latitude")
# Spatial SVMs (this can take about a minute to run)
svm.SP <- rangeSVM(sp1.xy, sp2.xy, sp3.xy, nrep=5)
# Use SVM to create a raster of predicted regions
rand_svm.SP <- rangeSVM_predict(svm = svm.SP, r = r1.sdm)
}
}
