% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{replace}
\alias{replace}
\alias{replace.figure}
\title{Replace figures (Method)}
\usage{
replace(obj, index, replacement, visible)

\method{replace}{figure}(obj, index, replacement, visible = FALSE)
}
\arguments{
\item{obj}{A figure composed of different figures}

\item{index}{integer, the index of the element to replace}

\item{replacement}{The figure with which the original one is replaced}

\item{visible}{logical, if TRUE it will replace only the visible figure. Default is FALSE}
}
\value{
An object with a changed figure

The starting object with a replaced figure

An object with a changed figure

The starting object with a replaced figure
}
\description{
Replace a figure with another figure
}
\section{Methods (by class)}{
\itemize{
\item \code{replace(figure)}: Replace figures

Replace a figure with another figure

}}
\examples{
# concanate three figures into an object
my_shapes <- cof(square(), triangle(), slice())
# draw object
draw(my_shapes)
# replace the square with a gray pacman
draw(replace(my_shapes, 1, pacman(shd = "grey")))
# concanate three figures into an object
my_shapes <- cof(square(), triangle(), slice())
# draw object
draw(my_shapes)
# replace the square with a gray pacman
draw(replace(my_shapes, 1, pacman(shd = "grey")))
}
