% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchMulti-package.R
\docType{package}
\name{matchMulti-package}
\alias{matchMulti-package}
\title{matchMulti Package}
\description{
\code{matchMulti} provides and easy to use set of functions to do matching
with multilevel data.  It is designed for use with grouped data such as
students in schools, where the user wishes to match a set of treated groups
to control groups to make the two groups more comparable.
}
\details{
This package will match treated groups to control groups, but allows for
trimming of both units and groups to increase balance.  There are also
functions for assessing balance after matching, estimating treatment effects
and performing sensitivity analysis for hidden confounders.
}
\examples{

\dontrun{
# Load Catholic school data
data(catholic_schools)

student.cov <- c('minority','female','ses','mathach')

# Check balance student balance before matching
balanceTable(catholic_schools[c(student.cov,'sector')],  treatment = 'sector')

#Match schools but not students within schools
match.simple <- matchMulti(catholic_schools, treatment = 'sector',
school.id = 'school', match.students = FALSE)

#Check balance after matching - this checks both student and school balance
balanceMulti(match.simple, student.cov = student.cov)

#Estimate treatment effect
output <- matchMultioutcome(match.simple, out.name = "mathach",
schl_id_name = "school",  treat.name = "sector")

# Perform sensitivity analysis using Rosenbaum bound -- increase Gamma to increase effect of
# possible hidden confounder 
         
matchMultisens(match.simple, out.name = "mathach",
          schl_id_name = "school", 
          treat.name = "sector", Gamma=1.3)
          
# Now match both schools and students within schools          
match.out <- matchMulti(catholic_schools, treatment = 'sector',
school.id = 'school', match.students = TRUE, student.vars = student.cov)

# Check balance again
bal.tab <- balanceMulti(match.out, student.cov = student.cov)

# Now match with fine balance constraints on whether the school is large 
# or has a high percentage of minority students
match.fb <- matchMulti(catholic_schools, treatment = 'sector', school.id = 'school', 
match.students = TRUE, student.vars = student.cov, 
school.fb = list(c('size_large'),c('size_large','minority_mean_large')))

# Estimate treatment effects
matchMultioutcome(match.fb, out.name = "mathach", schl_id_name = "school",  treat.name = "sector")

#Check Balance
balanceMulti(match.fb, student.cov = student.cov)
}

}
\seealso{
See also \code{\link{matchMulti}}, \code{\link{matchMultisens}},
\code{\link{balanceMulti}}, \code{\link{matchMultioutcome}},
\code{\link{rematchSchools}}
}
\author{
c("\\Sexpr[results=rd,stage=build]{tools:::Rd_package_author(\"#1\")}",
"matchMulti")\Sexpr{tools:::Rd_package_author("matchMulti")}

Maintainer:
c("\\Sexpr[results=rd,stage=build]{tools:::Rd_package_maintainer(\"#1\")}",
"matchMulti")\Sexpr{tools:::Rd_package_maintainer("matchMulti")}
}
\keyword{matchMulti}
