% Generated by roxygen2 (4.0.1): do not edit by hand
\name{daa}
\alias{daa}
\title{Deferred Acceptance Algorithm for two-sided matching markets}
\usage{
daa(nStudents = ncol(s.prefs), nColleges = ncol(c.prefs), nSlots = rep(1,
  nColleges), s.prefs = NULL, c.prefs = NULL)
}
\arguments{
\item{nStudents}{integer indicating the number of students (in the college admissions problem)
or men (in the stable marriage problem) in the market. Defaults to \code{ncol(s.prefs)}.}

\item{nColleges}{integer indicating the number of colleges (in the college admissions problem)
or women (in the stable marriage problem) in the market. Defaults to \code{ncol(c.prefs)}.}

\item{nSlots}{vector of length \code{nColleges} indicating the number of places (i.e.
quota) of each college. Defaults to \code{rep(1,nColleges)} for the marriage problem.}

\item{s.prefs}{matrix of dimension \code{nColleges} \code{x} \code{nStudents} with the \code{i}th
column containing student \code{i}'s ranking over colleges in decreasing order of
preference (i.e. most preferred first).}

\item{c.prefs}{matrix of dimension \code{nStudents} \code{x} \code{nColleges} with the \code{j}th
column containing college \code{j}'s ranking over students in decreasing order of
preference (i.e. most preferred first).}
}
\value{
\code{daa} returns a list with the following elements.
\item{s.prefs}{student-side preference matrix.}
\item{c.prefs}{college-side preference matrix.}
\item{iterations}{number of interations required to find the stable matching.}
\item{matches}{identifier of students/men assigned to colleges/women.}
\item{match.mat}{matching matrix of dimension \code{nStudents} \code{x} \code{nColleges}.}
\item{singles}{identifier of single (or unmatched) students/men.}
}
\description{
Finds the student-optimal matching in the
\href{http://en.wikipedia.org/wiki/Hospital_resident}{college admissions} problem or
the men-optimal matching in the
\href{http://en.wikipedia.org/wiki/Stable_matching}{stable marriage} problem.
Uses the Gale-Shapley (1962) Deferred Acceptance Algorithm with student/male
offer based on given or randomly generated preferences.
}
\section{Minimum required arguments}{

\code{daa} requires the following combination of arguments, subject to the matching problem.
\describe{
\item{\code{nStudents, nColleges}}{Marriage problem with random preferences.}
\item{\code{s.prefs, c.prefs}}{Marriage problem with given preferences.}
\item{\code{nStudents, nSlots}}{College admissions problem with random preferences.}
\item{\code{s.prefs, c.prefs, nSlots}}{College admissions problem with given preferences.}
}
}
\examples{
######################
## Marriage problem ##
######################

## 3 men, 2 women, random preferences:
daa(nStudents=3, nColleges=2)

## 3 men, 2 women, given preferences:
s.prefs <- matrix(c(1,2, 1,2, 1,2), 2,3)
c.prefs <- matrix(c(1,2,3, 1,2,3), 3,2)
daa(s.prefs=s.prefs, c.prefs=c.prefs)

###############################
## College admission problem ##
###############################

## 7 students, 2 colleges with 3 slots each, random preferences:
daa(nStudents=7, nSlots=c(3,3))

## 7 students, 2 colleges with 3 slots each, given preferences:
s.prefs <- matrix(c(1,2, 1,2, 1,2, 1,2, 1,2, 1,2, 1,2), 2,7)
c.prefs <- matrix(c(1,2,3,4,5,6,7, 1,2,3,4,5,6,7), 7,2)
daa(s.prefs=s.prefs, c.prefs=c.prefs, nSlots=c(3,3))
}
\author{
Thilo Klein
}
\references{
Gale, D. and Shapley, L.S. (1962). College admissions and the stability
of marriage. \emph{The American Mathematical Monthly}, 69(1):9--15.

Oswald, F. (2013). Deferred Acceptance Algorithm with male offer. GitHub Gist, Available at \url{https://gist.github.com/floswald/1628636}
}
\keyword{algorithms}

