% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_wrapper_ttc_check_stability}
\alias{cpp_wrapper_ttc_check_stability}
\title{Check if a one-sided matching for the top trading cycle algorithm is stable}
\usage{
cpp_wrapper_ttc_check_stability(pref, matchings)
}
\arguments{
\item{pref}{is a matrix with the preference order of all individuals in the
market. If there are \code{n} individuals, then this matrix will be of
dimension \code{n} by \code{n}. The \code{i,j}th element refers to
\code{j}'s \code{i}th most favorite partner. Preference orders must be
specified using C++ indexing (starting at 0).}

\item{matchings}{is a vector of length \code{n} corresponding to the
matchings being made, so that e.g. if the \code{4}th element is \code{5}
then agent \code{4} was matched to agent \code{6}. This vector uses C++
indexing that starts at 0.}
}
\value{
true if the matching is stable, false otherwise
}
\description{
Check if a one-sided matching for the top trading cycle algorithm is stable
}

