% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinants.R
\name{minor}
\alias{minor}
\title{Minor of A[i,j]}
\usage{
minor(A, i, j)
}
\arguments{
\item{A}{a square matrix}

\item{i}{row index}

\item{j}{column index}
}
\value{
the minor of A[i,j]
}
\description{
Returns the minor of element (i,j) of the square matrix A, i.e., the determinant of the
submatrix that results when row i and column j are deleted.
}
\examples{
M <- matrix(c(4, -12, -4,
              2,   1,  3,
             -1,  -3,  2), 3, 3, byrow=TRUE)
minor(M, 1, 1)
minor(M, 1, 2)
minor(M, 1, 3)
}
\author{
Michael Friendly
}
\seealso{
\code{\link{row_minors}} for all minors of a given row

Other determinants: \code{\link{cofactor}},
  \code{\link{row_cofactors}}, \code{\link{row_minors}}
}

