% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskal.R
\name{kruskalwallis}
\alias{kruskalwallis}
\alias{row_kruskalwallis}
\alias{col_kruskalwallis}
\title{Kruskal-Wallis Rank Sum Test}
\usage{
row_kruskalwallis(x, g)

col_kruskalwallis(x, g)
}
\arguments{
\item{x}{numeric matrix.}

\item{g}{a vector specifying group membership for each observation of x.}
}
\value{
a data.frame where each row contains the results of a Kruskal-Wallis
test performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs.tot - total number of observations\cr
2. obs.groups - number of groups\cr
4. df - degrees of freedom\cr
5. statistic - chi-squared statistic\cr
6. pvalue - p.value
}
\description{
Performs a Kruskal-Wallis rank sum test on each row/column of the input matrix.
}
\details{
\code{row_kruskalwallis(x, g)} - Kruskal Wallis test on rows.
\code{col_kruskalwallis(x, g)} - Kruskal Wallis test on columns.

Results should be the same as running \code{kruskal.test(x, g)}
on every row (or column) of \code{x}
}
\examples{
col_kruskalwallis(iris[,1:4], iris$Species)
row_kruskalwallis(t(iris[,1:4]), iris$Species)

}
\seealso{
\code{kruskal.test()}
}
\author{
Karolis Koncevičius
}
