% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox.R
\name{wilcoxon}
\alias{wilcoxon}
\alias{row_wilcoxon_twosample}
\alias{col_wilcoxon_twosample}
\alias{row_wilcoxon_onesample}
\alias{col_wilcoxon_onesample}
\alias{row_wilcoxon_paired}
\alias{col_wilcoxon_paired}
\title{Wilcoxon Test}
\usage{
row_wilcoxon_twosample(
  x,
  y,
  alternative = "two.sided",
  mu = 0,
  exact = NA,
  correct = TRUE
)

col_wilcoxon_twosample(
  x,
  y,
  alternative = "two.sided",
  mu = 0,
  exact = NA,
  correct = TRUE
)

row_wilcoxon_onesample(
  x,
  alternative = "two.sided",
  mu = 0,
  exact = NA,
  correct = TRUE
)

col_wilcoxon_onesample(
  x,
  alternative = "two.sided",
  mu = 0,
  exact = NA,
  correct = TRUE
)

row_wilcoxon_paired(
  x,
  y,
  alternative = "two.sided",
  mu = 0,
  exact = NA,
  correct = TRUE
)

col_wilcoxon_paired(
  x,
  y,
  alternative = "two.sided",
  mu = 0,
  exact = NA,
  correct = TRUE
)
}
\arguments{
\item{x}{numeric matrix.}

\item{y}{numeric matrix for the second group of observations.}

\item{alternative}{alternative hypothesis to use for each row/column of x.
A single string or a vector with values for each observation.
Values must be one of "two.sided" (default), "greater" or "less".}

\item{mu}{true values of the location shift for the null hypothesis.
A single number or numeric vector with values for each observation.}

\item{exact}{logical or NA (default) indicator whether an exact p-value
should be computed (see Details).
A single value or a logical vector with values for each observation.}

\item{correct}{logical indicator whether continuity correction should be
applied in the cases where p-values are obtained using normal approximation.
A single value or logical vector with values for each observation.}
}
\value{
a data.frame where each row contains the results of a wilcoxon test
performed on the corresponding row/column of x.
The columns will vary depending on the type of test performed.\cr\cr
They will contain a subset of the following information:\cr
1. obs.x - number of x observations\cr
2. obs.y - number of y observations\cr
3. obs.tot - total number of observations\cr
4. obs.paired - number of paired observations (present in x and y)\cr
5. statistic - Wilcoxon test statistic\cr
6. pvalue - p-value\cr
7. alternative - chosen alternative hypothesis\cr
8. location.null - location shift of the null hypothesis\cr
9. exact - indicates if exact p-value was computed\cr
10. correct - indicates if continuity correction was performed
}
\description{
Performs a Wilcoxon test on each row/column of the input matrix.
}
\details{
Functions to perform one sample and two sample Wilcoxon tests on rows/columns of matrices.
Main arguments and results were intentionally matched to the \code{wilcox.test()}
function from default stats package. Other arguments were split into separate
functions:

\code{row_wilcoxon_onesample(x)} - one sample Wilcoxon test on rows.
\code{col_wilcoxon_onesample(x)} - one sample Wilcoxon test on columns.

Results should be the same as running \code{wilcox.test(x)}
on every row (or column) of \code{x}.

\code{row_wilcoxon_twosample(x, y)} - two sample Wilcoxon test on rows.
\code{col_wilcoxon_twosample(x, y)} - two sample Wilcoxon test on columns.

Results should be the same as running \code{wilcox.test(x, y)}
on every row (or column) of \code{x} and \code{y}.

\code{row_wilcoxon_paired(x, y)} - two sample paired Wilcoxon test on rows.
\code{col_wilcoxon_paired(x, y)} - two sample paired Wilcoxon test on columns.

Results should be the same as running \code{wilcox.test(x, y, paired=TRUE)}
on every row (or column) of \code{x} and \code{y}.

By default if ‘exact’ argument is set to 'NA', exact p-values are computed
only if both 'x' and 'y' contain less than 50 finite values and there are no
ties. Single sample and paired tests have additional requirement of not
having zeroe values (values equal to null hypothesis location argument 'mu').
Otherwise, a normal approximation is used. Be wary of using 'exact=TRUE' on
large sample sizes as computations can take a very long time.

'correct' argument controls the continuity correction of p-values but only
when exact p-values cannot be computed and normal approximation is used.
For cases where exact p-values are returned 'correct' is switched to FALSE.
}
\note{
Confidence interval and pseudo-median calculations are not implemented.
}
\examples{
X <- iris[iris$Species=="setosa",1:4]
Y <- iris[iris$Species=="virginica",1:4]
col_wilcoxon_twosample(X, Y)

# same row using different alternative hypotheses
col_wilcoxon_twosample(X[,c(1,1,1)], Y[,c(1,1,1)], alternative=c("t", "g", "l"))

}
\seealso{
\code{wilcox.test()}
}
\author{
Karolis Koncevičius
}
