% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binary.R
\name{geometricmean_byname}
\alias{geometricmean_byname}
\title{Name- and element-wise geometric mean of two matrices.}
\usage{
geometricmean_byname(...)
}
\arguments{
\item{...}{operands; constants, matrices, or lists of matrices}
}
\value{
name-wise geometric mean of operands
}
\description{
Gives the geometric mean of corresponding entries of \code{a} and \code{b}.
}
\details{
This function performs a union and sorting of row and column names 
prior to performing geometric mean.
Zeroes are inserted for missing matrix elements.
}
\examples{
library(dplyr)
geometricmean_byname(10, 1000)
geometricmean_byname(10, 1000, 100000)
commoditynames <- c("c1", "c2")
industrynames <- "i1"
U <- matrix(c(10, 1000), ncol = 1, nrow = 2, dimnames = list(commoditynames, industrynames)) \%>\%
  setrowtype("Commodities") \%>\% setcoltype("Industries")
G <- matrix(c(1e3, 1e5), ncol = 1, nrow = 2, 
            dimnames = list(rev(commoditynames), rev(industrynames))) \%>\%
  setrowtype("Commodities") \%>\% setcoltype("Industries")
# Non-sensical. Row and column names not respected.
sqrt(U*G)
# Row and column names respected!
geometricmean_byname(U, G)
geometricmean_byname(1000, U)
geometricmean_byname(10, G)
# This also works with lists
geometricmean_byname(list(10, 1000), list(1000, 10))
geometricmean_byname(list(U,U), list(G,G))
DF <- data.frame(U = I(list()), G = I(list()))
DF[[1,"U"]] <- U
DF[[2,"U"]] <- U
DF[[1,"G"]] <- G
DF[[2,"G"]] <- G
geometricmean_byname(DF$U, DF$G)
DF \%>\% mutate(geomeans = geometricmean_byname(U, G))
}
