% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{vectorize_byname}
\alias{vectorize_byname}
\title{Vectorize a matrix}
\usage{
vectorize_byname(a, notation)
}
\arguments{
\item{a}{The matrix to be vectorized.}

\item{notation}{A string vector created by \code{notation_vec()}.}
}
\value{
A column vector containing all elements of \code{a}, with row names assigned as "rowname \code{sep} colname".
}
\description{
Converts a matrix into a column vector.
Each element of the matrix becomes an entry in the column vector,
with rows named via the \code{notation} argument.
Callers may want to transpose the matrix first with \code{transpose_byname()}.
}
\details{
The \code{notation} is also applied to \code{rowtype} and \code{coltype} attributes.
}
\examples{
m <- matrix(c(1, 5,
              4, 5),
            nrow = 2, ncol = 2, byrow = TRUE, 
            dimnames = list(c("p1", "p2"), c("i1", "i2"))) \%>\% 
  setrowtype("Products") \%>\% setcoltype("Industries")
m
vectorize_byname(m, notation = RCLabels::arrow_notation)
# If a single number is provided, the number will be returned as a 1x1 column vector 
# with some additional attributes.
vectorize_byname(42, notation = RCLabels::arrow_notation)
attributes(vectorize_byname(42, notation = RCLabels::arrow_notation))
}
