% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual.R
\name{visual}
\alias{visual}
\title{Visualize Cliff's delta and S-value}
\usage{
visual(rs, rotate = FALSE, display = TRUE)
}
\arguments{
\item{rs}{a list, output of \code{\link{mbr}}.}

\item{rotate}{a logical, whether to rotate the biomarker labels in figures.}

\item{display}{a logical, whether to display cell values in heatmaps.}
}
\value{
\code{visual} returns a list of ggplot objects:
  \item{\code{fig.delta}}{heatmap of Cliff's delta.}
  \item{\code{fig.sval}}{heatmap of S-value.} \item{\code{fig.avg}}{dot plot
  of the average of absolute Cliff’s delta.} \item{\code{mbr_fig}}{combined
  heatmaps of Cliff's delta and S-value.}
}
\description{
\code{visual} plots Cliff's delta and S-value for multiple groups and
multiple biomarkers.
}
\examples{
\donttest{
set.seed(1)
setting <- setpop()
temp <- simul(setting$pop_mean)
mbr_result <- mbr(temp$sam)
visual(mbr_result)
} #might take more than 5s in some machines

}
