% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_id_raster.R
\name{build_id_raster}
\alias{build_id_raster}
\title{Build ID raster}
\usage{
build_id_raster(polygons, template_raster = NULL)
}
\arguments{
\item{polygons}{\link[terra:SpatVector-class]{terra::SpatVector} object. The polygons to be aggregated to}

\item{template_raster}{(optional) \link[terra:SpatRaster-class]{terra::SpatRaster} object. The template raster should
contain and have the same CRS as the polygons. If template raster is \code{NULL}, the
default, uses the default world template raster from \code{make_world_template_raster()}.}
}
\value{
ID raster. A \link[terra:SpatRaster-class]{terra::SpatRaster} object that minimally encloses the polygons
}
\description{
Build an ID raster matching the extent of a vector dataset
}
\details{
The ID raster will be used to build the aggregation table. Each pixel has a
unique integer value from 1 to the number of pixels in the ID raster.
}
\examples{
\dontrun{
  polygons <- sf::st_read(system.file('extdata/Benin_communes.gpkg', package = 'mbg'))
  build_id_raster(polygons)
}
}
\concept{core_inputs}
