% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mcboost-package}
\alias{mcboost}
\alias{mcboost-package}
\title{mcboost: Multi-Calibration Boosting}
\description{
Implements 'Multi-Calibration Boosting' (2018) <https://proceedings.mlr.press/v80/hebert-johnson18a.html> and
    'Multi-Accuracy Boosting' (2019) <arXiv:1805.12317> for the multi-calibration of a machine learning model's prediction.
    'MCBoost' updates predictions for sub-groups in an iterative fashion in order to mitigate biases like poor calibration or large accuracy differences across subgroups.
    Multi-Calibration works best in scenarios where the underlying data & labels are unbiased, but resulting models are.
    This is often the case, e.g. when an algorithm fits a majority population while ignoring or under-fitting minority populations.
}
\references{
Kim et al., 2019: Multiaccuracy: Black-Box Post-Processing for Fairness in Classification.
Hebert-Johnson et al., 2018: Multicalibration: Calibration for the ({C}omputationally-Identifiable) Masses.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mlr-org/mcboost}
  \item Report bugs at \url{https://github.com/mlr-org/mcboost/issues}
}

}
\author{
\strong{Maintainer}: Florian Pfisterer \email{pfistererf@googlemail.com} (\href{https://orcid.org/0000-0001-8867-762X}{ORCID})

Other contributors:
\itemize{
  \item Susanne Dandl \email{susanne.dandl@stat.uni-muenchen.de} (\href{https://orcid.org/0000-0003-4324-4163}{ORCID}) [contributor]
  \item Christoph Kern \email{c.kern@uni-mannheim.de} (\href{https://orcid.org/0000-0001-7363-4299}{ORCID}) [contributor]
  \item Bernd Bischl \email{bernd_bischl@gmx.net} (\href{https://orcid.org/0000-0001-6002-6980}{ORCID}) [contributor]
}

}
