% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nchains.R, R/niters.R
\name{nchains}
\alias{nchains}
\alias{nchains.mcarray}
\alias{nchains.mcmc}
\alias{nchains.mcmc.list}
\alias{nchains.mcmcarray}
\alias{nchains.mcmcr}
\alias{nchains.mcmcrs}
\alias{niters.mcarray}
\alias{niters.mcmc}
\alias{niters.mcmc.list}
\alias{niters.mcmcarray}
\alias{niters.mcmcr}
\alias{niters.mcmcrs}
\title{Number of MCMC chains}
\usage{
nchains(x, ...)

\method{nchains}{mcarray}(x, ...)

\method{nchains}{mcmc}(x, ...)

\method{nchains}{mcmc.list}(x, ...)

\method{nchains}{mcmcarray}(x, ...)

\method{nchains}{mcmcr}(x, ...)

\method{nchains}{mcmcrs}(x, ...)

\method{niters}{mcarray}(x, ...)

\method{niters}{mcmc}(x, ...)

\method{niters}{mcmc.list}(x, ...)

\method{niters}{mcmcarray}(x, ...)

\method{niters}{mcmcr}(x, ...)

\method{niters}{mcmcrs}(x, ...)
}
\arguments{
\item{x}{An MCMC object}

\item{...}{Unused}
}
\value{
A count indicating the number of MCMC chains
}
\description{
Gets the number of MCMC chains.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcarray}: Number of MCMC chains for an mcarray object

\item \code{mcmc}: Number of MCMC chains for an mcmc object

\item \code{mcmc.list}: Number of MCMC chains for an mcmc.list object

\item \code{mcmcarray}: Number of MCMC chains for an mcmcarray object

\item \code{mcmcr}: Number of MCMC chains for an mcmcr object

\item \code{mcmcrs}: Number of MCMC chains for an mcmcrs object

\item \code{mcarray}: Number of MCMC iterations for an mcarray object

\item \code{mcmc}: Number of MCMC iterations for an mcmc object

\item \code{mcmc.list}: Number of MCMC iterations for an mcmc.list object

\item \code{mcmcarray}: Number of MCMC iterations for an mcmcarray object

\item \code{mcmcr}: Number of MCMC iterations for an mcmcr object

\item \code{mcmcrs}: Number of MCMC iterations for an mcmcrs object
}}

\examples{
nchains(mcmcr_example)
}
