% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-pars.R
\name{set_pars.mcmc}
\alias{set_pars.mcmc}
\title{Set Parameters}
\usage{
\method{set_pars}{mcmc}(x, value, ...)
}
\arguments{
\item{x}{An object.}

\item{value}{A character vector of the new parameter names.}

\item{...}{Other arguments passed to methods.}
}
\value{
The modified object.
}
\description{
Sets an object's parameter names.

The assignment version \verb{pars<-()} forwards to \code{set_pars()}.
}
\details{
\code{value} must be a unique character vector of the same length as the
object's parameters.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

nlist <-  nlist(x = 1, y = 3:4)
pars(nlist) <- c("a", "b")
nlist
set_pars(nlist, c("z", "c1"))
\dontshow{\}) # examplesIf}
}
\seealso{
Other parameters: 
\code{\link[universals]{npars}()},
\code{\link[universals]{pars}()}
}
