% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{transform_dc}
\alias{transform_dc}
\title{Transform one or more draws components into a new one by applying a function}
\usage{
transform_dc(..., fun, to.matrix = FALSE, labels = NULL)
}
\arguments{
\item{...}{draws component object(s).}

\item{fun}{a function to apply. This function should take as many arguments as there are input objects.
The arguments can be arbitrarily named, but they are assumed to be in the same order as the input objects.
The function should return a vector.}

\item{to.matrix}{if \code{TRUE} the output is in matrix format; otherwise it is a draws component object.}

\item{labels}{optional labels for the output object.}
}
\value{
Either a matrix or a draws component.
}
\description{
Transform one or more draws components into a new one by applying a function
}
\examples{
\donttest{
ex <- mcmcsae_example(n=50)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, n.chain=4, store.all=TRUE)
summary(sim$v_sigma)
summary(transform_dc(sim$v_sigma, fun=function(x) x^2))
summary(transform_dc(sim$u, sim$u_sigma, fun=function(x1, x2) abs(x1)/x2))
}

}
